/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.configuration.SpawnLayerConfig;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SpawnLayer
extends WorldLayer {
    public static final String KEY = "pl3xmap_spawn";
    private final String icon = SpawnLayerConfig.ICON;

    public SpawnLayer(World world) {
        super(KEY, world, () -> Lang.UI_LAYER_SPAWN);
        Path icon = FileUtil.getWebDir().resolve("images/icon/" + this.icon + ".png");
        try {
            IconImage image = new IconImage(this.icon, ImageIO.read(icon.toFile()), "png");
            Pl3xMap.api().getIconRegistry().register(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setUpdateInterval(SpawnLayerConfig.UPDATE_INTERVAL);
        this.setLiveUpdate(SpawnLayerConfig.LIVE_UPDATE);
        this.setShowControls(SpawnLayerConfig.SHOW_CONTROLS);
        this.setDefaultHidden(SpawnLayerConfig.DEFAULT_HIDDEN);
        this.setPriority(SpawnLayerConfig.PRIORITY);
        this.setZIndex(SpawnLayerConfig.Z_INDEX);
        String tooltip = this.getLabel();
        if (!tooltip.isBlank()) {
            this.setOptions(Options.builder().tooltipContent(tooltip).tooltipDirection(Tooltip.Direction.TOP).build());
        }
    }

    @Override
    public Collection<Marker<?>> getMarkers() {
        return Collections.singletonList(Marker.icon(KEY, this.getWorld().getSpawn(), this.icon, 16.0).setOptions(this.getOptions()));
    }
}

