/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.configuration.WorldBorderLayerConfig;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WorldBorderLayer
extends WorldLayer {
    public static final String KEY = "pl3xmap_worldborder";
    private final Polyline polyline = (Polyline)Marker.polyline("pl3xmap_worldborder", new Point[0]).setOptions(this.getOptions());

    public WorldBorderLayer(World world) {
        this(KEY, world, () -> Lang.UI_LAYER_WORLDBORDER);
        this.setUpdateInterval(WorldBorderLayerConfig.UPDATE_INTERVAL);
        this.setLiveUpdate(WorldBorderLayerConfig.LIVE_UPDATE);
        this.setShowControls(WorldBorderLayerConfig.SHOW_CONTROLS);
        this.setDefaultHidden(WorldBorderLayerConfig.DEFAULT_HIDDEN);
        this.setPriority(WorldBorderLayerConfig.PRIORITY);
        this.setZIndex(WorldBorderLayerConfig.Z_INDEX);
        this.setOptions(Options.builder().strokeColor(Colors.fromHex(WorldBorderLayerConfig.STROKE_COLOR)).strokeWeight(WorldBorderLayerConfig.STROKE_WEIGHT).strokeDashOffset(WorldBorderLayerConfig.STROKE_DASH_OFFSET).strokeDashPattern(WorldBorderLayerConfig.STROKE_DASH_PATTERN).strokeLineCapShape(WorldBorderLayerConfig.STROKE_LINE_CAP_SHAPE).strokeLineJoinShape(WorldBorderLayerConfig.STROKE_LINE_JOIN_SHAPE).tooltipContent(this.getLabel()).tooltipSticky(true).tooltipDirection(Tooltip.Direction.TOP).build());
    }

    public WorldBorderLayer(String key, World world, Supplier<String> labelSupplier) {
        super(key, world, labelSupplier);
    }

    @Override
    public Collection<Marker<?>> getMarkers() {
        return Collections.singletonList(this.polyline.clearPoints().addPoint(Point.of(this.getWorld().getBorderMinX(), this.getWorld().getBorderMinZ()), Point.of(this.getWorld().getBorderMaxX(), this.getWorld().getBorderMinZ()), Point.of(this.getWorld().getBorderMaxX(), this.getWorld().getBorderMaxZ()), Point.of(this.getWorld().getBorderMinX(), this.getWorld().getBorderMaxZ()), Point.of(this.getWorld().getBorderMinX(), this.getWorld().getBorderMinZ())).setOptions(this.getOptions()));
    }
}

