/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MultiPolygon
extends Marker<MultiPolygon> {
    private final List<Polygon> polygons = new ArrayList<Polygon>();

    private MultiPolygon(String key) {
        super("multipoly", key);
    }

    public MultiPolygon(String key, Polygon polygon) {
        this(key);
        this.addPolygon(polygon);
    }

    public MultiPolygon(String key, Polygon ... polygons) {
        this(key);
        this.addPolygon(polygons);
    }

    public MultiPolygon(String key, Collection<Polygon> polygons) {
        this(key);
        this.addPolygon(polygons);
    }

    public static MultiPolygon of(String key, Polygon polygon) {
        return new MultiPolygon(key, polygon);
    }

    public static MultiPolygon of(String key, Polygon ... polygons) {
        return new MultiPolygon(key, polygons);
    }

    public static MultiPolygon of(String key, Collection<Polygon> polygons) {
        return new MultiPolygon(key, polygons);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    public MultiPolygon clearPolygons() {
        this.polygons.clear();
        return this;
    }

    public MultiPolygon addPolygon(Polygon polygon) {
        Preconditions.checkNotNull(polygon, "MultiPolygon polygon is null");
        this.polygons.add(polygon);
        return this;
    }

    public MultiPolygon addPolygon(Polygon ... polygons) {
        Preconditions.checkNotNull(polygons, "MultiPolygon polygons is null");
        for (Polygon polygon : polygons) {
            this.addPolygon(polygon);
        }
        return this;
    }

    public MultiPolygon addPolygon(Collection<Polygon> polygons) {
        Preconditions.checkNotNull(polygons, "MultiPolygon polygons is null");
        this.polygons.addAll(polygons);
        return this;
    }

    public MultiPolygon removePoly(Polygon polygon) {
        Preconditions.checkNotNull(polygon, "MultiPolygon polygon is null");
        this.polygons.remove(polygon);
        return this;
    }

    public MultiPolygon removePoly(Polygon ... polygons) {
        Preconditions.checkNotNull(polygons, "MultiPolygon polygons is null");
        for (Polygon polygon : polygons) {
            this.removePoly(polygon);
        }
        return this;
    }

    public MultiPolygon removePoly(Collection<Polygon> polygons) {
        Preconditions.checkNotNull(polygons, "MultiPolygon polygons is null");
        this.polygons.removeAll(polygons);
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("polygons", this.getPolygons());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static MultiPolygon fromJson(JsonObject obj) {
        MultiPolygon multiPolygon = MultiPolygon.of(obj.get("key").getAsString(), new Polygon[0]);
        JsonElement el = obj.get("polygons");
        if (el != null && !(el instanceof JsonNull)) {
            JsonArray arr = el.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                multiPolygon.addPolygon(Polygon.fromJson((JsonObject)arr.get(i)));
            }
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            multiPolygon.setPane(el.getAsString());
        }
        return multiPolygon;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MultiPolygon other = (MultiPolygon)o;
        return this.getKey().equals(other.getKey()) && Objects.equals(this.getPolygons(), other.getPolygons()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getPolygons(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "MultiPolygon{key=" + this.getKey() + ",polygons=" + String.valueOf(this.getPolygons()) + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

