/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.option.Option;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Stroke
extends Option<Stroke> {
    private Boolean enabled;
    private Integer weight;
    private Integer color;
    private LineCapShape lineCapShape;
    private LineJoinShape lineJoinShape;
    private String dashPattern;
    private String dashOffset;

    public Stroke() {
    }

    public Stroke(boolean enabled) {
        this.setEnabled(enabled);
    }

    public Stroke(int weight, int color) {
        this.setWeight(weight);
        this.setColor(color);
    }

    public @Nullable Boolean isEnabled() {
        return this.enabled;
    }

    public Stroke setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public @Nullable Integer getWeight() {
        return this.weight;
    }

    public Stroke setWeight(@Nullable Integer weight) {
        this.weight = weight;
        return this;
    }

    public @Nullable Integer getColor() {
        return this.color;
    }

    public Stroke setColor(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    public @Nullable LineCapShape getLineCapShape() {
        return this.lineCapShape;
    }

    public Stroke setLineCapShape(@Nullable LineCapShape lineCapShape) {
        this.lineCapShape = lineCapShape;
        return this;
    }

    public @Nullable LineJoinShape getLineJoinShape() {
        return this.lineJoinShape;
    }

    public Stroke setLineJoinShape(@Nullable LineJoinShape lineJoinShape) {
        this.lineJoinShape = lineJoinShape;
        return this;
    }

    public @Nullable String getDashPattern() {
        return this.dashPattern;
    }

    public Stroke setDashPattern(@Nullable String dashPattern) {
        this.dashPattern = dashPattern;
        return this;
    }

    public @Nullable String getDashOffset() {
        return this.dashOffset;
    }

    public Stroke setDashOffset(@Nullable String dashOffset) {
        this.dashOffset = dashOffset;
        return this;
    }

    @Override
    public boolean isDefault() {
        return !(this.isEnabled() != null && !Boolean.TRUE.equals(this.isEnabled()) || this.getWeight() != null && this.getWeight() != 3 || this.getColor() != null && this.getColor() != -13399809 || this.getLineCapShape() != null && this.getLineCapShape() != LineCapShape.ROUND || this.getLineJoinShape() != null && this.getLineJoinShape() != LineJoinShape.ROUND || this.getDashPattern() != null || this.getDashOffset() != null);
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("enabled", this.isEnabled());
        wrapper.addProperty("weight", this.getWeight());
        wrapper.addProperty("color", this.getColor());
        wrapper.addProperty("lineCap", this.getLineCapShape());
        wrapper.addProperty("lineJoin", this.getLineJoinShape());
        wrapper.addProperty("dashArray", this.getDashPattern());
        wrapper.addProperty("dashOffset", this.getDashOffset());
        return wrapper.getJsonObject();
    }

    public static Stroke fromJson(JsonObject obj) {
        Stroke stroke = new Stroke();
        JsonElement el = obj.get("enabled");
        if (el != null && !(el instanceof JsonNull)) {
            stroke.setEnabled(el.getAsBoolean());
        }
        if ((el = obj.get("weight")) != null && !(el instanceof JsonNull)) {
            stroke.setWeight(el.getAsInt());
        }
        if ((el = obj.get("color")) != null && !(el instanceof JsonNull)) {
            stroke.setColor(el.getAsInt());
        }
        if ((el = obj.get("lineCap")) != null && !(el instanceof JsonNull)) {
            stroke.setLineCapShape(LineCapShape.values()[el.getAsInt()]);
        }
        if ((el = obj.get("lineJoin")) != null && !(el instanceof JsonNull)) {
            stroke.setLineJoinShape(LineJoinShape.values()[el.getAsInt()]);
        }
        if ((el = obj.get("dashArray")) != null && !(el instanceof JsonNull)) {
            stroke.setDashPattern(el.getAsString());
        }
        if ((el = obj.get("dashOffset")) != null && !(el instanceof JsonNull)) {
            stroke.setDashOffset(el.getAsString());
        }
        return stroke;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Stroke other = (Stroke)o;
        return Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.getWeight(), other.getWeight()) && Objects.equals(this.getColor(), other.getColor()) && Objects.equals((Object)this.getLineCapShape(), (Object)other.getLineCapShape()) && Objects.equals((Object)this.getLineJoinShape(), (Object)other.getLineJoinShape()) && Objects.equals(this.getDashPattern(), other.getDashPattern()) && Objects.equals(this.getDashOffset(), other.getDashOffset());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled(), this.getWeight(), this.getColor(), this.getLineCapShape(), this.getLineJoinShape(), this.getDashPattern(), this.getDashOffset()});
    }

    public String toString() {
        return "Stroke{enabled=" + this.isEnabled() + ",weight=" + this.getWeight() + ",color=" + this.getColor() + ",lineCapShape=" + String.valueOf((Object)this.getLineCapShape()) + ",lineJoinShape=" + String.valueOf((Object)this.getLineJoinShape()) + ",dashPattern=" + this.getDashPattern() + ",dashOffset=" + this.getDashOffset() + "}";
    }

    public static enum LineCapShape {
        BUTT,
        ROUND,
        SQUARE;

    }

    public static enum LineJoinShape {
        MITER,
        ROUND,
        BEVEL;

    }
}

