/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.pl3x.map.core.configuration.PlayersLayerConfig;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PlayerRegistry
extends Registry<Player> {
    public Player getOrDefault(UUID uuid, Supplier<Player> supplier) {
        Player player = this.get(uuid);
        if (player == null) {
            player = supplier.get();
            this.register(player.getUUID(), player);
        }
        return player;
    }

    public Player register(UUID uuid, Player player) {
        Preconditions.checkNotNull(uuid, "UUID cannot be null");
        Preconditions.checkNotNull(player, "Player cannot be null");
        return super.register(uuid.toString(), player);
    }

    public @Nullable Player unregister(UUID uuid) {
        return (Player)super.unregister(uuid.toString());
    }

    public @Nullable Player get(UUID uuid) {
        return (Player)super.get(uuid.toString());
    }

    @Override
    public @Nullable Player get(String name) {
        String lowercaseName = name.toLowerCase(Locale.ROOT);
        for (Player player : this.values()) {
            if (!player.getName().toLowerCase(Locale.ROOT).equals(lowercaseName)) continue;
            return player;
        }
        return null;
    }

    public Optional<Player> optional(UUID uuid) {
        Player player = this.get(uuid);
        return player == null ? Optional.empty() : Optional.of(player);
    }

    public List<Object> parsePlayers() {
        if (!PlayersLayerConfig.ENABLED) {
            return Collections.emptyList();
        }
        ArrayList<Object> players = new ArrayList<Object>();
        this.forEach(player -> {
            if (player.isHidden() || player.isNPC()) {
                return;
            }
            if (PlayersLayerConfig.HIDE_SPECTATORS && player.isSpectator()) {
                return;
            }
            if (PlayersLayerConfig.HIDE_INVISIBLE && player.isInvisible()) {
                return;
            }
            LinkedHashMap<String, Object> playerEntry = new LinkedHashMap<String, Object>();
            playerEntry.put("name", player.getDecoratedName());
            playerEntry.put("uuid", player.getUUID().toString());
            playerEntry.put("displayName", player.getDecoratedName());
            playerEntry.put("world", player.getWorld().getName());
            playerEntry.put("position", player.getPosition());
            players.add(playerEntry);
        });
        return players;
    }
}

