/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Registry<T extends Keyed>
implements Iterable<T> {
    protected final Map<String, T> entries = new ConcurrentHashMap<String, T>();

    public T register(T value) {
        return this.register(((Keyed)value).getKey(), value);
    }

    public T register(String id, T value) {
        Preconditions.checkNotNull(id, "Id cannot be null");
        Preconditions.checkNotNull(value, "Value cannot be null");
        this.entries.put(id, value);
        return value;
    }

    public @Nullable T unregister(String id) {
        return (T)((Keyed)this.entries.remove(id));
    }

    public void unregister() {
        Collections.unmodifiableSet(this.entries.keySet()).forEach(this::unregister);
    }

    public boolean has(String key) {
        return this.entries.containsKey(key);
    }

    public @Nullable T get(String id) {
        return (T)((Keyed)this.entries.get(id));
    }

    public T getOrDefault(String id, T def) {
        return (T)((Keyed)this.entries.getOrDefault(id, def));
    }

    public Set<Map.Entry<String, T>> entrySet() {
        return this.entries.entrySet();
    }

    public Collection<T> values() {
        return this.entries.values();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entries.values().iterator();
    }
}

