/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import java.lang.reflect.InvocationTargetException;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.renderer.BasicRenderer;
import net.pl3x.map.core.renderer.BiomeRenderer;
import net.pl3x.map.core.renderer.BlockInfoRenderer;
import net.pl3x.map.core.renderer.FlowerMapRenderer;
import net.pl3x.map.core.renderer.InhabitedRenderer;
import net.pl3x.map.core.renderer.NetherRoofRenderer;
import net.pl3x.map.core.renderer.NightRenderer;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.VanillaRenderer;
import net.pl3x.map.core.renderer.VintageStoryRenderer;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RendererRegistry
extends Registry<Renderer.Builder> {
    public static final String BASIC = "basic";
    public static final String BIOMES = "biomes";
    public static final String BLOCKINFO = "blockinfo";
    public static final String FLOWERMAP = "flowermap";
    public static final String INHABITED = "inhabited";
    public static final String NIGHT = "night";
    public static final String VANILLA = "vanilla";
    public static final String VINTAGE_STORY = "vintage_story";
    public static final String NETHER_ROOF = "nether_roof";

    public void register() {
        this.register(BASIC, new Renderer.Builder(BASIC, "Basic", BasicRenderer.class));
        this.register(BIOMES, new Renderer.Builder(BIOMES, "Biomes", BiomeRenderer.class));
        this.register(BLOCKINFO, new Renderer.Builder(BLOCKINFO, "BlockInfo", BlockInfoRenderer.class));
        this.register(FLOWERMAP, new Renderer.Builder(FLOWERMAP, "FlowerMap", FlowerMapRenderer.class));
        this.register(INHABITED, new Renderer.Builder(INHABITED, "Inhabited", InhabitedRenderer.class));
        this.register(NIGHT, new Renderer.Builder(NIGHT, "Night", NightRenderer.class));
        this.register(VANILLA, new Renderer.Builder(VANILLA, "Vanilla", VanillaRenderer.class));
        this.register(VINTAGE_STORY, new Renderer.Builder(VINTAGE_STORY, "VintageStory", VintageStoryRenderer.class));
        this.register(NETHER_ROOF, new Renderer.Builder(NETHER_ROOF, "NetherRoof", NetherRoofRenderer.class));
    }

    public Renderer createRenderer(RegionScanTask task, Renderer.Builder builder) {
        try {
            return builder.getClazz().getConstructor(RegionScanTask.class, Renderer.Builder.class).newInstance(task, builder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

