/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import net.pl3x.map.core.configuration.ColorsConfig;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BiomeRenderer
extends Renderer {
    public BiomeRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
        int pixelColor = 0;
        if (data.getBlockState().getBlock().color() > 0) {
            Biome biome = data.getBiome(region, blockX, blockZ);
            int color = ColorsConfig.BIOME_COLORS.getOrDefault(biome.getKey(), 0);
            pixelColor = Colors.setAlpha(255, color);
            if (data.getFluidState() == null) {
                pixelColor = Colors.blend(this.getHeightmap().getColor(region, blockX, blockZ), pixelColor);
            }
        }
        this.getTileImage().setPixel(blockX, blockZ, pixelColor);
    }
}

