/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegionFileWatcher
implements Runnable {
    private final World world;
    private Timer timer;
    private TimerTask task;
    private Thread thread;
    private boolean stopped;

    public RegionFileWatcher(World world) {
        this.world = world;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean verbose) {
        if (!Pl3xMap.api().isEnabled()) {
            return;
        }
        if (verbose) {
            Logger.debug("Starting region file watcher for " + this.world.getName());
        }
        this.stop(false);
        this.timer = new Timer();
        this.task = new TimerTask(this){

            @Override
            public void run() {
            }
        };
        this.timer.schedule(this.task, 10000L);
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean verbose) {
        if (verbose) {
            Logger.debug("Stopping region file watcher for " + this.world.getName());
        }
        this.stopped = true;
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        Path dir = this.world.getRegionDirectory();
        try (WatchService watcher2 = dir.getFileSystem().newWatchService();){
            WatchKey key;
            dir.register(watcher2, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            Logger.debug("Region file watcher started for " + String.valueOf(dir));
            while ((key = watcher2.take()) != null) {
                HashSet<Path> modifiedFiles = new HashSet<Path>();
                Logger.debug("Region file watcher got a key!");
                for (WatchEvent<?> event : key.pollEvents()) {
                    Logger.debug("Region file watcher detected event: " + event.kind().name());
                    if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                    Path file = (Path)event.context();
                    Logger.debug("Detected file change: " + String.valueOf(file.getFileName()));
                    modifiedFiles.add(dir.resolve(file));
                }
                key.reset();
                Collection<Point> points = FileUtil.regionPathsToPoints(this.world, modifiedFiles, true);
                Pl3xMap.api().getRegionProcessor().addRegions(this.world, points);
            }
        }
        catch (InterruptedException | ClosedWatchServiceException watcher2) {
        }
        catch (IOException e) {
            Logger.severe("Failed to create a new file watcher for directory %s".formatted(dir.toAbsolutePath()), e);
        }
        if (this.stopped) {
            Logger.debug("Region file watcher stopped!");
        } else {
            Logger.debug("Region file watcher stopped! Trying to start again..");
            this.start(false);
        }
    }
}

