/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.renderer.progress.Progress;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.util.SpiralIterator;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegionProcessor {
    private final Map<World, Collection<Point>> regionsToScan = new ConcurrentHashMap<World, Collection<Point>>();
    private final Deque<Ticket> ticketsToScan = new ConcurrentLinkedDeque<Ticket>();
    private final Executor executor = Pl3xMap.ThreadFactory.createService("Pl3xMap-Processor");
    private final Progress progress = new Progress();
    private CompletableFuture<Void> future;
    private boolean paused;
    private long timeStarted;
    private boolean running;

    public void checkPaused() {
        while (this.isPaused()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public Set<World> getQueuedWorlds() {
        return this.regionsToScan.keySet();
    }

    public void start(long delay) {
        this.future = CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isPaused()) {
                this.run();
            }
            this.start(5000L);
        }, this.executor);
    }

    public void stop() {
        this.progress.stop();
        if (this.future != null) {
            boolean result = this.future.cancel(true);
            Logger.debug("Stopped region processor: " + result);
        }
    }

    public void addRegions(World world, Collection<Point> regions) {
        for (Point region : regions) {
            Ticket ticket = new Ticket(world, region);
            if (this.ticketsToScan.contains(ticket)) continue;
            this.ticketsToScan.add(ticket);
        }
    }

    private void run() {
        if (this.running) {
            Logger.debug("Region processor already running!");
            return;
        }
        this.running = true;
        this.timeStarted = System.currentTimeMillis();
        Logger.debug("Region processor started queuing at " + this.timeStarted);
        try {
            while (!this.ticketsToScan.isEmpty()) {
                Ticket ticket = this.ticketsToScan.poll();
                if (ticket == null) continue;
                Collection set = this.regionsToScan.getOrDefault(ticket.world, new HashSet());
                set.add(ticket.region);
                this.regionsToScan.put(ticket.world, set);
            }
            Iterator<Map.Entry<World, Collection<Point>>> iter = this.regionsToScan.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<World, Collection<Point>> entry = iter.next();
                iter.remove();
                World world = entry.getKey();
                Collection<Point> regions = entry.getValue();
                this.process(world, regions);
            }
        }
        catch (Throwable t) {
            Logger.severe("Region processor failed to process tickets", t);
        }
        this.running = false;
        Logger.debug("Region processor finished queuing at " + System.currentTimeMillis());
    }

    private void process(World world, Collection<Point> regionPositions) {
        Logger.debug(world.getName() + " Region processor started processing at " + System.currentTimeMillis());
        Point spawn = world.getSpawn();
        SpiralIterator spiralIterator = new SpiralIterator(spawn.x() >> 9, spawn.z() >> 9);
        ArrayList<Point> orderedRegionsToScan = new ArrayList<Point>();
        int totalRegions = regionPositions.size();
        int numberOfFoundRegions = 0;
        int numberOfSkippedRegions = 0;
        while (numberOfFoundRegions < totalRegions) {
            if (numberOfSkippedRegions > 1000000) {
                Logger.debug("Failsafe triggered.");
                orderedRegionsToScan.addAll(regionPositions);
                break;
            }
            Point regionPos = spiralIterator.next();
            if (regionPositions.remove(regionPos)) {
                orderedRegionsToScan.add(regionPos);
                ++numberOfFoundRegions;
                numberOfSkippedRegions = 0;
                continue;
            }
            ++numberOfSkippedRegions;
        }
        this.schedule(world, orderedRegionsToScan);
        Logger.debug(world.getName() + " Region processor finished processing at " + System.currentTimeMillis());
    }

    private void schedule(World world, List<Point> orderedRegionsToScan) {
        this.getProgress().setWorld(world);
        this.getProgress().setTotalRegions(orderedRegionsToScan.size());
        this.getProgress().setTotalChunks(this.getProgress().getTotalRegions() * 1024L);
        ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])orderedRegionsToScan.stream().map(pos -> CompletableFuture.runAsync(new RegionScanTask(world, (Point)pos), Pl3xMap.api().getRenderExecutor()).whenComplete((result, throwable) -> {
            if (throwable != null) {
                Logger.severe("Failed to run region scan task for %s".formatted(world.getName(), pos), throwable);
            }
            world.getRegionModifiedState().set(Mathf.asLong(pos), this.timeStarted);
            if (Config.GC_WHEN_RUNNING) {
                System.gc();
            }
        })).toArray(CompletableFuture[]::new)).whenComplete((result, throwable) -> {
            if (throwable != null) {
                Logger.severe("Failed to run region scan tasks for world %s".formatted(world.getName()), throwable);
            }
            this.getProgress().finish();
            world.cleanup();
            if (Config.GC_WHEN_FINISHED) {
                System.gc();
            }
            this.running = false;
            Logger.debug(world.getName() + " Region processor finished task at " + System.currentTimeMillis());
        })).join();
    }

    private record Ticket(World world, Point region) {
    }
}

