/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.scheduler;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.scheduler.Task;
import net.pl3x.map.core.util.TickUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Scheduler {
    private final Queue<Task> tasks = new ConcurrentLinkedQueue<Task>();
    private boolean ticking;

    public void tick() {
        if (this.ticking) {
            return;
        }
        this.ticking = true;
        try {
            Iterator iter = this.tasks.iterator();
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                if (task.tick++ < task.delay) continue;
                if (task.cancelled()) {
                    iter.remove();
                    continue;
                }
                task.run();
                if (task.repeat) {
                    task.tick = 0;
                    continue;
                }
                iter.remove();
            }
        }
        catch (Throwable t) {
            Logger.severe("Failed to tick a task", t);
        }
        this.ticking = false;
    }

    public void cancelAll() {
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            ((Task)iter.next()).cancel();
            iter.remove();
        }
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void addTask(int delay, Runnable runnable) {
        this.addTask(delay, false, runnable);
    }

    public void addTask(int delay, Runnable runnable, boolean ticks) {
        this.addTask(delay, false, runnable, ticks);
    }

    public void addTask(int delay, boolean repeat, Runnable runnable) {
        this.addTask(delay, repeat, runnable, false);
    }

    public void addTask(int delay, boolean repeat, final Runnable runnable, boolean ticks) {
        this.addTask(new Task(this, ticks ? delay : TickUtil.toTicks(delay), repeat){

            @Override
            public void run() {
                runnable.run();
            }
        });
    }
}

