/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.Objects;
import net.pl3x.map.core.Keyed;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Biome
extends Keyed {
    public static final Biome DEFAULT = new Biome(0, "minecraft:default", 112, 10387789, 7579470, 9353585, 4159204, (x, z, def) -> def);
    private final int index;
    private final int color;
    private final int foliage;
    private final int dryFoliage;
    private final int grass;
    private final int water;
    private final GrassModifier grassModifier;

    public Biome(int index, String key, int color, int dryFoliage, int foliage, int grass, int water, GrassModifier grassModifier) {
        super(key);
        this.index = index;
        this.color = color;
        this.foliage = foliage;
        this.dryFoliage = dryFoliage;
        this.grass = grass;
        this.water = water;
        this.grassModifier = grassModifier;
    }

    public int grass(int x, int z) {
        return this.grassModifier().modify(x, z, this.grass());
    }

    public int index() {
        return this.index;
    }

    public int color() {
        return this.color;
    }

    public int dryFoliage() {
        return this.dryFoliage;
    }

    public int foliage() {
        return this.foliage;
    }

    public int grass() {
        return this.grass;
    }

    public int water() {
        return this.water;
    }

    public GrassModifier grassModifier() {
        return this.grassModifier;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Biome other = (Biome)obj;
        return this.index == other.index && this.getKey().equals(other.getKey()) && this.color == other.color && this.foliage == other.foliage && this.grass == other.grass && this.water == other.water && Objects.equals(this.grassModifier, other.grassModifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.getKey(), this.color, this.foliage, this.grass, this.water, this.grassModifier);
    }

    @Override
    public String toString() {
        return "Biome[index=" + this.index + ", key=" + this.getKey() + ", color=" + this.color + ", dryFoliage=" + this.dryFoliage + ", foliage=" + this.foliage + ", grass=" + this.grass + ", water=" + this.water + ", grassModifier=" + String.valueOf(this.grassModifier) + "]";
    }

    @FunctionalInterface
    public static interface GrassModifier {
        public int modify(int var1, int var2, int var3);
    }
}

