/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.Objects;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.configuration.ColorsConfig;
import net.pl3x.map.core.world.BlockState;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Block
extends Keyed {
    private final int index;
    private final int color;
    private final int vanilla;
    private final byte bools;
    private final BlockState defaultState;

    public Block(int index, String id, int vanilla) {
        super(id);
        this.index = index;
        this.color = ColorsConfig.BLOCK_COLORS.getOrDefault(id, vanilla);
        this.vanilla = vanilla;
        boolean flat = ColorsConfig.BLOCKS_FLAT.contains(id);
        boolean air = ColorsConfig.BLOCKS_AIR.contains(id);
        boolean foliage = ColorsConfig.BLOCKS_FOLIAGE.contains(id);
        boolean dryFoliage = ColorsConfig.BLOCKS_DRY_FOLIAGE.contains(id);
        boolean grass = ColorsConfig.BLOCKS_GRASS.contains(id);
        boolean water = ColorsConfig.BLOCKS_WATER.contains(id);
        boolean glass = ColorsConfig.BLOCKS_GLASS.contains(id);
        this.bools = (byte)((dryFoliage ? 128 : 0) | (flat ? 64 : 0) | (air ? 32 : 0) | (foliage ? 16 : 0) | (grass ? 8 : 0) | (water ? 4 : 0) | (glass ? 2 : 0) | (water || "minecraft:lava".equals(id) ? 1 : 0));
        this.defaultState = new BlockState(this);
    }

    public int getIndex() {
        return this.index;
    }

    public int color() {
        return this.color;
    }

    public int vanilla() {
        return this.vanilla;
    }

    public boolean isDryFoliage() {
        return (this.bools >> 7 & 1) > 0;
    }

    public boolean isFlat() {
        return (this.bools >> 6 & 1) > 0;
    }

    public boolean isAir() {
        return (this.bools >> 5 & 1) > 0;
    }

    public boolean isFoliage() {
        return (this.bools >> 4 & 1) > 0;
    }

    public boolean isGrass() {
        return (this.bools >> 3 & 1) > 0;
    }

    public boolean isWater() {
        return (this.bools >> 2 & 1) > 0;
    }

    public boolean isGlass() {
        return (this.bools >> 1 & 1) > 0;
    }

    public boolean isFluid() {
        return (this.bools & 1) > 0;
    }

    public BlockState getDefaultState() {
        return this.defaultState;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Block other = (Block)o;
        return Objects.equals(this.getKey(), other.getKey()) && this.color() == other.color() && this.getIndex() == other.getIndex() && this.bools == other.bools && this.getDefaultState().equals(other.defaultState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.color(), this.getIndex(), this.bools, this.getDefaultState());
    }

    @Override
    public String toString() {
        return "BlockState{key=" + this.getKey() + "index=" + this.getIndex() + "color=" + this.color() + "isAir=" + this.isAir() + "isFluid=" + this.isFluid() + "isFoliage=" + this.isFoliage() + "isGrass=" + this.isGrass() + "isWater=" + this.isWater() + "isGlass=" + this.isGlass() + "defaultBlockState=" + String.valueOf(this.getDefaultState()) + "}";
    }
}

