/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.Map;
import net.pl3x.map.core.world.Block;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BlockState {
    private final Block block;
    private final byte age;
    private final byte moisture;
    private final byte power;

    public BlockState(Block block) {
        this.block = block;
        this.power = (byte)-1;
        this.moisture = (byte)-1;
        this.age = (byte)-1;
    }

    public BlockState(Block block, Map<String, String> properties) {
        this.block = block;
        int age = -1;
        int moisture = -1;
        int power = -1;
        if (!properties.isEmpty()) {
            String powerProperty;
            String moistureProperty;
            String ageProperty = properties.get("age");
            if (ageProperty != null) {
                try {
                    age = Integer.valueOf(ageProperty).byteValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((moistureProperty = properties.get("moisture")) != null) {
                try {
                    moisture = Integer.valueOf(moistureProperty).byteValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((powerProperty = properties.get("power")) != null) {
                try {
                    power = Integer.valueOf(powerProperty).byteValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.age = (byte)age;
        this.moisture = (byte)moisture;
        this.power = (byte)power;
    }

    public Block getBlock() {
        return this.block;
    }

    public byte getAge() {
        return this.age;
    }

    public byte getMoisture() {
        return this.moisture;
    }

    public byte getPower() {
        return this.power;
    }
}

