/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libs.net.querz.nbt.tag.ByteArrayTag;
import libs.net.querz.nbt.tag.CompoundTag;
import libs.net.querz.nbt.tag.IntArrayTag;
import libs.net.querz.nbt.tag.ListTag;
import libs.net.querz.nbt.tag.StringTag;
import libs.net.querz.nbt.tag.Tag;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.util.MCAMath;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.Blocks;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.LegacyBiomes;
import net.pl3x.map.core.world.Region;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ChunkAnvil115
extends Chunk {
    private Section[] sections = new Section[0];
    private int[] biomes;
    protected long[] worldSurfaceHeights = new long[0];
    private final boolean full;

    protected ChunkAnvil115(World world, Region region, CompoundTag chunkTag, int index) {
        super(world, region, chunkTag, index);
        Tag<?> tag;
        CompoundTag levelData = chunkTag.getCompoundTag("Level");
        this.full = levelData.getString("Status").equals("full");
        if (!this.full) {
            return;
        }
        if (levelData.containsKey("Heightmaps")) {
            CompoundTag heightmaps = levelData.getCompoundTag("Heightmaps");
            this.worldSurfaceHeights = heightmaps.getLongArray("WORLD_SURFACE");
        }
        if (levelData.containsKey("Sections")) {
            this.sections = new Section[32];
            for (CompoundTag sectionTag : levelData.getListTag("Sections").asCompoundTagList()) {
                Section section = new Section(sectionTag);
                if (section.sectionY < 0 || section.sectionY >= this.sections.length) continue;
                this.sections[section.sectionY] = section;
            }
        }
        if ((tag = levelData.get("Biomes")) instanceof ByteArrayTag) {
            byte[] bs = (byte[])((ByteArrayTag)tag).getValue();
            this.biomes = new int[bs.length];
            for (int i = 0; i < bs.length; ++i) {
                this.biomes[i] = bs[i] & 0xFF;
            }
        } else if (tag instanceof IntArrayTag) {
            this.biomes = (int[])((IntArrayTag)tag).getValue();
        }
        if (this.biomes == null || this.biomes.length == 0) {
            this.biomes = new int[1024];
        }
        if (this.biomes.length < 1024) {
            this.biomes = Arrays.copyOf(this.biomes, 1024);
        }
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        int sectionY = y >> 4;
        if (sectionY < 0 || sectionY >= this.sections.length) {
            return Blocks.AIR.getDefaultState();
        }
        Section section = this.sections[sectionY];
        return section == null ? Blocks.AIR.getDefaultState() : section.getBlockState(x, y, z);
    }

    @Override
    public int getLight(int x, int y, int z) {
        int sectionY = y >> 4;
        if (sectionY < 0 || sectionY >= this.sections.length) {
            return y < 0 ? 0 : this.getWorld().getSkylight();
        }
        Section section = this.sections[sectionY];
        return section == null ? this.getWorld().getSkylight() : section.getLight(x, y, z);
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        int index = (y >> 2 << 4) + ((z & 0xF) >> 2 << 2) + ((x & 0xF) >> 2);
        if (index < 0) {
            return Biome.DEFAULT;
        }
        if (index >= this.biomes.length) {
            return Biome.DEFAULT;
        }
        Biome biome = LegacyBiomes.get(this.biomes[index]);
        return biome == null ? Biome.DEFAULT : biome;
    }

    @Override
    public boolean noHeightmap() {
        return this.worldSurfaceHeights.length < 36;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        if (this.noHeightmap()) {
            return 0;
        }
        return (int)MCAMath.getValueFromLongStream(this.worldSurfaceHeights, ((z & 0xF) << 4) + (x & 0xF), 9);
    }

    protected static class Section {
        private final int sectionY;
        private byte[] blockLight;
        private long[] blocks;
        private BlockState[] palette = new BlockState[0];
        private final int bitsPerBlock;

        public Section(CompoundTag sectionData) {
            this.sectionY = sectionData.getNumber("Y").intValue();
            this.blockLight = sectionData.getByteArray("BlockLight");
            this.blocks = sectionData.getLongArray("BlockStates");
            if (this.blocks.length < 256 && this.blocks.length > 0) {
                this.blocks = Arrays.copyOf(this.blocks, 256);
            }
            if (this.blockLight.length < 2048 && this.blockLight.length > 0) {
                this.blockLight = Arrays.copyOf(this.blockLight, 2048);
            }
            if (sectionData.containsKey("palette")) {
                ListTag<CompoundTag> paletteTag = sectionData.getListTag("palette").asCompoundTagList();
                this.palette = new BlockState[paletteTag.size()];
                for (int i = 0; i < this.palette.length; ++i) {
                    CompoundTag stateTag = paletteTag.get(i);
                    String id = stateTag.getString("Name");
                    Block block = Pl3xMap.api().getBlockRegistry().getOrDefault(id, Blocks.AIR);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    CompoundTag propertiesTag = stateTag.getCompoundTag("Properties");
                    if (propertiesTag != null) {
                        for (Map.Entry<String, Tag<?>> property : propertiesTag) {
                            properties.put(property.getKey().toLowerCase(), ((StringTag)property.getValue()).getValue().toLowerCase());
                        }
                    }
                    this.palette[i] = new BlockState(block, properties);
                }
            }
            this.bitsPerBlock = this.blocks.length >> 6;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.palette.length == 1) {
                return this.palette[0];
            }
            if (this.blocks.length == 0) {
                return Blocks.AIR.getDefaultState();
            }
            int index = ((y & 0xF) << 8) + ((z & 0xF) << 4) + (x & 0xF);
            long value = MCAMath.getValueFromLongStream(this.blocks, index, this.bitsPerBlock);
            if (value >= (long)this.palette.length) {
                return Blocks.AIR.getDefaultState();
            }
            return this.palette[(int)value];
        }

        public int getLight(int x, int y, int z) {
            if (this.blockLight.length == 0) {
                return 0;
            }
            int index = ((y & 0xF) << 8) + ((z & 0xF) << 4) + (x & 0xF);
            int half = index >> 1;
            boolean upper = (index & 1) != 0;
            return MCAMath.getByteHalf(this.blockLight[half], upper);
        }
    }
}

