/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.client;

import java.util.concurrent.ExecutorService;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.scheduler.Scheduler;
import net.pl3x.map.fabric.client.duck.MapInstance;
import net.pl3x.map.fabric.client.manager.TileManager;
import net.pl3x.map.fabric.common.network.ClientboundMapPayload;
import net.pl3x.map.fabric.common.network.ClientboundServerPayload;
import net.pl3x.map.fabric.common.network.ServerboundMapPayload;
import net.pl3x.map.fabric.common.network.ServerboundServerPayload;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class Pl3xMapFabricClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(Pl3xMapFabricClient.class);
    private static Pl3xMapFabricClient instance;
    private static final class_304.class_11900 PL3XMAP_KEYMAP_CATEGORY;
    private static final class_304 PL3XMAP_TOGGLE_KEYMAP;
    private final Scheduler scheduler;
    private final TileManager tileManager;
    private final ExecutorService executor = Pl3xMap.ThreadFactory.createService("Pl3xMap-Update");
    private boolean isEnabled;
    private boolean isOnServer;
    private String serverUrl;
    private int tick;

    public static Pl3xMapFabricClient getInstance() {
        return instance;
    }

    public Pl3xMapFabricClient() {
        instance = this;
        this.scheduler = new Scheduler();
        this.tileManager = new TileManager(this);
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)PL3XMAP_TOGGLE_KEYMAP);
        PayloadTypeRegistry.playC2S().register(ServerboundServerPayload.TYPE, ServerboundServerPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundServerPayload.TYPE, ClientboundServerPayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundMapPayload.TYPE, ServerboundMapPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundMapPayload.TYPE, ClientboundMapPayload.STREAM_CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundServerPayload.TYPE, ClientboundServerPayload::handle);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundMapPayload.TYPE, ClientboundMapPayload::handle);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (client.method_47392()) {
                return;
            }
            this.setEnabled(true);
            this.setIsOnServer(true);
            this.getScheduler().addTask(0, () -> ClientPlayNetworking.send((class_8710)new ServerboundServerPayload(3)));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.getScheduler().cancelAll();
            this.setEnabled(false);
            this.setIsOnServer(false);
            this.setServerUrl(null);
            this.getTileManager().clear();
            this.updateAllMapTextures();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            while (PL3XMAP_TOGGLE_KEYMAP.method_1436()) {
                this.isEnabled = !this.isEnabled;
                class_5250 onOff = class_2561.method_43471((String)("pl3xmap.toggled." + (this.isEnabled ? "on" : "off")));
                class_5250 component = class_2561.method_43469((String)"pl3xmap.toggled.response", (Object[])new Object[]{onOff});
                class_310.method_1551().field_1724.method_7353((class_2561)component, true);
            }
            if (this.tick++ >= 20) {
                this.tick = 0;
                this.getScheduler().tick();
            }
        });
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public TileManager getTileManager() {
        return this.tileManager;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isOnServer() {
        return this.isOnServer;
    }

    public void setIsOnServer(boolean isOnServer) {
        this.isOnServer = isOnServer;
    }

    public @Nullable String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public void updateAllMapTextures() {
        class_310.method_1551().method_61963().field_53646.values().forEach(tex -> ((MapInstance)tex).pl3xMap$updateImage());
    }

    static {
        PL3XMAP_KEYMAP_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"pl3xmap", (String)"title"));
        PL3XMAP_TOGGLE_KEYMAP = new class_304("pl3xmap.keymap.toggle", 77, PL3XMAP_KEYMAP_CATEGORY);
    }
}

