/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.client.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import net.pl3x.map.core.scheduler.Task;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.util.TickUtil;
import net.pl3x.map.fabric.client.Pl3xMapFabricClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TileManager {
    private static final BufferedImage EMPTY_IMAGE = new BufferedImage(512, 512, 2);
    private final Map<String, LoadingCache<Long, BufferedImage>> tiles = new ConcurrentHashMap<String, LoadingCache<Long, BufferedImage>>();
    private final Pl3xMapFabricClient mod;
    private Task task;

    public TileManager(Pl3xMapFabricClient mod) {
        this.mod = mod;
    }

    public void initialize() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.mod.getScheduler().addTask(0, this::update);
        this.task = new Task(TickUtil.toTicks(5), true){

            @Override
            public void run() {
                TileManager.this.update();
            }
        };
        this.mod.getScheduler().addTask(this.task);
    }

    public BufferedImage get(String world, int regionX, int regionZ) {
        try {
            return (BufferedImage)this.tiles.computeIfAbsent(world, k -> Loader.create(this.mod, world)).get((Object)Mathf.asLong(regionX, regionZ));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.tiles.forEach((world, cache) -> cache.invalidateAll());
        this.tiles.clear();
    }

    public void update() {
        if (RenderSystem.isOnRenderThread()) {
            this.mod.getExecutor().submit(this::update);
            return;
        }
        for (Map.Entry<String, LoadingCache<Long, BufferedImage>> entry : this.tiles.entrySet()) {
            LoadingCache<Long, BufferedImage> cache = entry.getValue();
            Collections.unmodifiableCollection(cache.asMap().keySet()).forEach(arg_0 -> cache.refresh(arg_0));
        }
        this.mod.updateAllMapTextures();
    }

    private static class Loader
    extends CacheLoader<Long, BufferedImage> {
        private final Pl3xMapFabricClient mod;
        private final String world;

        private static LoadingCache<Long, BufferedImage> create(Pl3xMapFabricClient mod, String world) {
            return CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new Loader(mod, world));
        }

        private Loader(Pl3xMapFabricClient mod, String world) {
            this.mod = mod;
            this.world = world;
        }

        public BufferedImage load(Long region) {
            if (this.mod.getServerUrl() == null) {
                return EMPTY_IMAGE;
            }
            String url = String.format("%s/tiles/%s/%d/%s/%d_%d.png", this.mod.getServerUrl(), this.world, 0, "vintage_story", Mathf.longToX(region), Mathf.longToZ(region));
            BufferedImage image = null;
            try (CloseableHttpClient httpclient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet(url));
                 InputStream stream = response.getEntity().getContent();){
                image = ImageIO.read(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return image == null ? EMPTY_IMAGE : image;
        }
    }
}

