/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.server;

import com.google.common.io.ByteArrayDataOutput;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9209;
import net.minecraft.server.MinecraftServer;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.network.Network;
import net.pl3x.map.fabric.common.network.ClientboundMapPayload;
import net.pl3x.map.fabric.common.network.ClientboundServerPayload;
import net.pl3x.map.fabric.common.network.ServerboundMapPayload;
import net.pl3x.map.fabric.common.network.ServerboundServerPayload;
import net.pl3x.map.fabric.server.Pl3xMapFabricServer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FabricNetwork
extends Network {
    private final Pl3xMapFabricServer mod;

    public FabricNetwork(Pl3xMapFabricServer mod) {
        this.mod = mod;
    }

    @Override
    public void register() {
        PayloadTypeRegistry.playC2S().register(ServerboundServerPayload.TYPE, ServerboundServerPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundServerPayload.TYPE, ClientboundServerPayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundMapPayload.TYPE, ServerboundMapPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundMapPayload.TYPE, ClientboundMapPayload.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ServerboundServerPayload.TYPE, (payload, context) -> ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new ClientboundServerPayload(3, 200, Config.WEB_ADDRESS)));
        ServerPlayNetworking.registerGlobalReceiver(ServerboundMapPayload.TYPE, (payload, context) -> this.sendMapData(context.player(), payload.mapId()));
    }

    @Override
    public void unregister() {
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)ServerboundServerPayload.TYPE.comp_2242());
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)ServerboundMapPayload.TYPE.comp_2242());
    }

    @Override
    protected <T> void sendServerData(T player) {
    }

    @Override
    protected <T> void sendMapData(T player, int id) {
    }

    @Override
    protected <T> void send(T player, ByteArrayDataOutput out) {
    }

    protected <T> void sendMapData(class_3222 player, int id) {
        MinecraftServer server = this.mod.getServer();
        if (server == null) {
            return;
        }
        class_22 map = class_1806.method_7997((class_9209)new class_9209(id), (class_1937)server.method_3847(class_1937.field_25179));
        if (map == null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundMapPayload(3, -1, id));
            return;
        }
        class_3218 level = this.mod.getServer().method_3847(map.field_118);
        if (level == null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundMapPayload(3, -2, id));
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundMapPayload(3, 200, id, map.field_119, map.field_116, map.field_115, level.method_27983().method_29177().toString().replace(":", "-")));
    }
}

