/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.class_1324;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.world.World;
import net.pl3x.map.fabric.server.FabricWorld;
import net.pl3x.map.fabric.server.duck.AccessServerPlayer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FabricPlayer
extends Player {
    public FabricPlayer(class_3222 player) {
        super(player.method_5820(), player);
    }

    public class_3222 getPlayer() {
        return (class_3222)super.getPlayer();
    }

    @Override
    public String getName() {
        return this.getPlayer().method_5820();
    }

    @Override
    public UUID getUUID() {
        return this.getPlayer().method_5667();
    }

    @Override
    public World getWorld() {
        class_3218 level = this.getPlayer().method_51469();
        String name = level.method_27983().method_29177().toString();
        return Pl3xMap.api().getWorldRegistry().getOrDefault(name, () -> new FabricWorld(level, name));
    }

    @Override
    public Point getPosition() {
        class_243 loc = this.getPlayer().method_73189();
        return Point.of(loc.method_10216(), loc.method_10215());
    }

    @Override
    public float getYaw() {
        return this.getPlayer().method_36454();
    }

    @Override
    public int getHealth() {
        return Math.round(this.getPlayer().method_6032());
    }

    @Override
    public int getArmorPoints() {
        class_1324 attr = this.getPlayer().method_5996(class_5134.field_23724);
        return attr == null ? 0 : (int)Math.round(attr.method_6194());
    }

    @Override
    public @Nullable URL getSkin() {
        try {
            Property property = this.getPlayer().method_7334().properties().get((Object)"textures").stream().findFirst().orElse(null);
            if (property == null) {
                return null;
            }
            String json = new String(Base64.getDecoder().decode(property.value()), StandardCharsets.UTF_8);
            JsonElement jsonElement = JsonParser.parseString((String)json);
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject().getAsJsonObject("textures");
            if (jsonObject == null) {
                return null;
            }
            JsonObject skin = jsonObject.get("SKIN").getAsJsonObject();
            if (skin == null) {
                return null;
            }
            String url = skin.get("url").getAsString();
            if (url == null) {
                return null;
            }
            return new URI(url).toURL();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isInvisible() {
        return this.getPlayer().method_5767();
    }

    @Override
    public boolean isNPC() {
        return false;
    }

    @Override
    public boolean isSpectator() {
        return this.getPlayer().method_7325();
    }

    @Override
    public boolean isPersistentlyHidden() {
        return ((AccessServerPlayer)this.getPlayer()).pl3xMap$isHidden();
    }

    @Override
    public void setPersistentlyHidden(boolean hidden) {
        ((AccessServerPlayer)this.getPlayer()).pl3xMap$setHidden(hidden);
    }

    @Override
    public String toString() {
        return "FabricPlayer{player=" + String.valueOf(this.getPlayer().method_5667()) + "}";
    }
}

