/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.incendo.cloud.parser.ParserParameter;

@API(status=API.Status.STABLE)
public final class ParserParameters {
    private final Map<ParserParameter<?>, Object> internalMap = new HashMap();

    public static @NonNull ParserParameters empty() {
        return new ParserParameters();
    }

    public static <T> @NonNull ParserParameters single(@NonNull ParserParameter<T> parameter, @NonNull T value) {
        ParserParameters parameters = new ParserParameters();
        parameters.store(parameter, value);
        return parameters;
    }

    public <T> boolean has(@NonNull ParserParameter<T> parameter) {
        return this.internalMap.containsKey(parameter);
    }

    public <T> void store(@NonNull ParserParameter<T> parameter, @NonNull T value) {
        this.internalMap.put(parameter, value);
    }

    public <T> @NonNull T get(@NonNull ParserParameter<T> parameter, @NonNull T defaultValue) {
        return (T)this.internalMap.getOrDefault(parameter, defaultValue);
    }

    public void merge(@NonNull ParserParameters other) {
        this.internalMap.putAll(other.internalMap);
    }

    public @NonNull Map<@NonNull ParserParameter<?>, @NonNull Object> parameters() {
        return Collections.unmodifiableMap(this.internalMap);
    }
}

