/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import java.net.InetSocketAddress;
import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;

public class LocalPortAttribute
implements ExchangeAttribute {
    public static final String LOCAL_PORT_SHORT = "%p";
    public static final String LOCAL_PORT = "%{LOCAL_PORT}";
    public static final ExchangeAttribute INSTANCE = new LocalPortAttribute();

    private LocalPortAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress localAddress = (InetSocketAddress)exchange.getConnection().getLocalAddress();
        return Integer.toString(localAddress.getPort());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Local port", newValue);
    }

    public String toString() {
        return LOCAL_PORT;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Local Port";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(LocalPortAttribute.LOCAL_PORT) || token.equals(LocalPortAttribute.LOCAL_PORT_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

