/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.util.Attachable;
import libs.io.undertow.util.AttachmentKey;
import libs.io.undertow.util.HeaderMap;
import libs.io.undertow.util.HttpString;
import libs.org.xnio.Bits;
import libs.org.xnio.conduits.Conduit;

class ChunkReader<T extends Conduit> {
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_READING_LENGTH = 0x2000000000000000L;
    private static final long FLAG_READING_TILL_END_OF_LINE = 0x1000000000000000L;
    private static final long FLAG_READING_NEWLINE = 0x800000000000000L;
    private static final long FLAG_READING_AFTER_LAST = 0x400000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 56);
    private static final long LIMIT = 0x7FFFFFFFFFFFFFFL;
    private long state;
    private final Attachable attachable;
    private final AttachmentKey<HeaderMap> trailerAttachmentKey;
    private TrailerParser trailerParser;
    private final T conduit;

    ChunkReader(Attachable attachable, AttachmentKey<HeaderMap> trailerAttachmentKey, T conduit) {
        this.attachable = attachable;
        this.trailerAttachmentKey = trailerAttachmentKey;
        this.conduit = conduit;
        this.state = 0x2000000000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readChunk(ByteBuffer buf) throws IOException {
        long oldVal = this.state;
        long chunkRemaining = this.state & MASK_COUNT;
        if (chunkRemaining > 0L && !Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return chunkRemaining;
        }
        long newVal = oldVal & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL);
        try {
            byte b2;
            if (Bits.anyAreSet(oldVal, 0x400000000000000L)) {
                int ret = this.handleChunkedRequestEnd(buf);
                if (ret == -1) {
                    newVal |= 0x4000000000000000L;
                    long l = -1L;
                    return l;
                }
                long l = 0L;
                return l;
            }
            while (Bits.anyAreSet(newVal, 0x800000000000000L)) {
                while (buf.hasRemaining()) {
                    b2 = buf.get();
                    if (b2 != 10) continue;
                    newVal = newVal & 0xF7FFFFFFFFFFFFFFL | 0x2000000000000000L;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x800000000000000L)) continue;
                long b2 = 0L;
                return b2;
            }
            while (Bits.anyAreSet(newVal, 0x2000000000000000L)) {
                while (buf.hasRemaining()) {
                    b2 = buf.get();
                    if (b2 >= 48 && b2 <= 57 || b2 >= 97 && b2 <= 102 || b2 >= 65 && b2 <= 70) {
                        if (chunkRemaining > 0x7FFFFFFFFFFFFFFL) {
                            throw UndertowMessages.MESSAGES.chunkSizeTooLarge();
                        }
                        chunkRemaining <<= 4;
                        chunkRemaining += (long)Character.digit((char)b2, 16);
                        continue;
                    }
                    if (b2 == 10) {
                        newVal &= 0xDFFFFFFFFFFFFFFFL;
                        break;
                    }
                    newVal = newVal & 0xDFFFFFFFFFFFFFFFL | 0x1000000000000000L;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x2000000000000000L)) continue;
                long b3 = 0L;
                return b3;
            }
            while (Bits.anyAreSet(newVal, 0x1000000000000000L)) {
                while (buf.hasRemaining()) {
                    if (buf.get() != 10) continue;
                    newVal &= 0xEFFFFFFFFFFFFFFFL;
                    break;
                }
                if (!Bits.anyAreSet(newVal, 0x1000000000000000L)) continue;
                long b3 = 0L;
                return b3;
            }
            if (Bits.allAreClear(newVal, 0x3800000000000000L) && chunkRemaining == 0L) {
                newVal |= 0x400000000000000L;
                int ret = this.handleChunkedRequestEnd(buf);
                if (ret == -1) {
                    newVal |= 0x4000000000000000L;
                    long l = -1L;
                    return l;
                }
                long l = 0L;
                return l;
            }
            long l = chunkRemaining;
            return l;
        }
        finally {
            this.state = newVal | chunkRemaining;
        }
    }

    public long getChunkRemaining() {
        if (Bits.anyAreSet(this.state, 0x4000000000000000L)) {
            return -1L;
        }
        if (Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return 0L;
        }
        return this.state & MASK_COUNT;
    }

    public void setChunkRemaining(long remaining) {
        if (remaining < 0L || Bits.anyAreSet(this.state, 0x3C00000000000000L)) {
            return;
        }
        long old = this.state;
        long oldRemaining = old & MASK_COUNT;
        if (remaining == 0L && oldRemaining != 0L) {
            old |= 0x800000000000000L;
        }
        this.state = old & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL) | remaining;
    }

    private int handleChunkedRequestEnd(ByteBuffer buffer) throws IOException {
        if (this.trailerParser != null) {
            return this.trailerParser.handle(buffer);
        }
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 10) {
                return -1;
            }
            if (b == 13) continue;
            buffer.position(buffer.position() - 1);
            this.trailerParser = new TrailerParser();
            return this.trailerParser.handle(buffer);
        }
        return 0;
    }

    private final class TrailerParser {
        private HeaderMap headerMap = new HeaderMap();
        private StringBuilder builder = new StringBuilder();
        private HttpString httpString;
        int state = 0;
        private static final int STATE_TRAILER_NAME = 0;
        private static final int STATE_TRAILER_VALUE = 1;
        private static final int STATE_ENDING = 2;

        private TrailerParser() {
        }

        public int handle(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                byte b = buf.get();
                if (this.state == 0) {
                    if (b == 13) {
                        if (this.builder.length() == 0) {
                            this.state = 2;
                            continue;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b == 10) {
                        if (this.builder.length() == 0) {
                            ChunkReader.this.attachable.putAttachment(ChunkReader.this.trailerAttachmentKey, this.headerMap);
                            return -1;
                        }
                        throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                    }
                    if (b == 58) {
                        this.httpString = HttpString.tryFromString(this.builder.toString().trim());
                        this.state = 1;
                        this.builder.setLength(0);
                        continue;
                    }
                    this.builder.append((char)b);
                    continue;
                }
                if (this.state == 1) {
                    if (b == 10) {
                        this.headerMap.put(this.httpString, this.builder.toString().trim());
                        this.httpString = null;
                        this.builder.setLength(0);
                        this.state = 0;
                        continue;
                    }
                    if (b == 13) continue;
                    this.builder.append((char)b);
                    continue;
                }
                if (this.state == 2) {
                    if (b == 10) {
                        if (ChunkReader.this.attachable != null) {
                            ChunkReader.this.attachable.putAttachment(ChunkReader.this.trailerAttachmentKey, this.headerMap);
                        }
                        return -1;
                    }
                    throw UndertowMessages.MESSAGES.couldNotDecodeTrailers();
                }
                throw new IllegalStateException();
            }
            return 0;
        }
    }
}

