/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import libs.io.undertow.protocols.http2.ConnectionErrorException;
import libs.io.undertow.protocols.http2.Http2FrameHeaderParser;
import libs.io.undertow.protocols.http2.Http2PushBackParser;
import libs.org.xnio.Bits;

class Http2DataFrameParser
extends Http2PushBackParser {
    private int padding = 0;

    Http2DataFrameParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser headerParser) throws ConnectionErrorException {
        if (Bits.anyAreClear(headerParser.flags, 8)) {
            this.finish();
            return;
        }
        if (headerParser.length == 0) {
            throw new ConnectionErrorException(1);
        }
        if (resource.remaining() > 0) {
            this.padding = resource.get() & 0xFF;
            --headerParser.length;
            if (this.padding > headerParser.length) {
                throw new ConnectionErrorException(1);
            }
            this.finish();
        }
    }

    int getPadding() {
        return this.padding;
    }
}

