/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.protocols.http2.ConnectionErrorException;
import libs.io.undertow.protocols.http2.Http2Channel;
import libs.io.undertow.protocols.http2.Http2DataFrameParser;
import libs.io.undertow.protocols.http2.Http2DiscardParser;
import libs.io.undertow.protocols.http2.Http2GoAwayParser;
import libs.io.undertow.protocols.http2.Http2HeadersParser;
import libs.io.undertow.protocols.http2.Http2PingParser;
import libs.io.undertow.protocols.http2.Http2PriorityParser;
import libs.io.undertow.protocols.http2.Http2PushBackParser;
import libs.io.undertow.protocols.http2.Http2PushPromiseParser;
import libs.io.undertow.protocols.http2.Http2RstStreamParser;
import libs.io.undertow.protocols.http2.Http2SettingsParser;
import libs.io.undertow.protocols.http2.Http2StreamSourceChannel;
import libs.io.undertow.protocols.http2.Http2WindowUpdateParser;
import libs.io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import libs.io.undertow.server.protocol.framed.FrameHeaderData;
import libs.org.xnio.Bits;

class Http2FrameHeaderParser
implements FrameHeaderData {
    final byte[] header = new byte[9];
    int read = 0;
    int length;
    int type;
    int flags;
    int streamId;
    Http2PushBackParser parser = null;
    Http2HeadersParser continuationParser = null;
    private static final int SECOND_RESERVED_MASK = -129;
    private Http2Channel http2Channel;

    Http2FrameHeaderParser(Http2Channel http2Channel, Http2HeadersParser continuationParser) {
        this.http2Channel = http2Channel;
        this.continuationParser = continuationParser;
    }

    public boolean handle(ByteBuffer byteBuffer) throws IOException {
        if (this.parser == null) {
            if (!this.parseFrameHeader(byteBuffer)) {
                return false;
            }
            if (this.continuationParser != null && this.type != 9) {
                throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.expectedContinuationFrame());
            }
            switch (this.type) {
                case 0: {
                    if (this.streamId == 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustNotBeZeroForFrameType(0));
                    }
                    this.parser = new Http2DataFrameParser(this.length);
                    break;
                }
                case 1: {
                    if (this.streamId == 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustNotBeZeroForFrameType(1));
                    }
                    this.parser = new Http2HeadersParser(this.length, this.http2Channel.getDecoder(), this.http2Channel.isClient(), this.http2Channel.getMaxHeaders(), this.streamId, this.http2Channel.getMaxHeaderListSize());
                    if (!Bits.allAreClear(this.flags, 4)) break;
                    this.continuationParser = (Http2HeadersParser)this.parser;
                    break;
                }
                case 3: {
                    if (this.length != 4) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.incorrectFrameSize());
                    }
                    this.parser = new Http2RstStreamParser(this.length);
                    break;
                }
                case 9: {
                    if (this.continuationParser == null) {
                        this.http2Channel.sendGoAway(1);
                        throw UndertowMessages.MESSAGES.http2ContinuationFrameNotExpected();
                    }
                    if (this.continuationParser.getStreamId() != this.streamId) {
                        this.http2Channel.sendGoAway(1);
                        throw UndertowMessages.MESSAGES.http2ContinuationFrameNotExpected();
                    }
                    this.parser = this.continuationParser;
                    if (this.continuationParser.moreData(this.length)) break;
                    this.http2Channel.sendGoAway(1);
                    break;
                }
                case 5: {
                    this.parser = new Http2PushPromiseParser(this.length, this.http2Channel.getDecoder(), this.http2Channel.isClient(), this.http2Channel.getMaxHeaders(), this.streamId, this.http2Channel.getMaxHeaderListSize());
                    if (!Bits.allAreClear(this.flags, 4)) break;
                    this.continuationParser = (Http2HeadersParser)this.parser;
                    break;
                }
                case 7: {
                    if (this.streamId != 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustBeZeroForFrameType(7));
                    }
                    this.parser = new Http2GoAwayParser(this.length);
                    break;
                }
                case 6: {
                    if (this.length != 8) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.invalidPingSize());
                    }
                    if (this.streamId != 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustBeZeroForFrameType(6));
                    }
                    this.parser = new Http2PingParser(this.length);
                    break;
                }
                case 4: {
                    if (this.length % 6 != 0) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.incorrectFrameSize());
                    }
                    if (this.streamId != 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustBeZeroForFrameType(4));
                    }
                    this.parser = new Http2SettingsParser(this.length);
                    break;
                }
                case 8: {
                    if (this.length != 4) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.incorrectFrameSize());
                    }
                    this.parser = new Http2WindowUpdateParser(this.length);
                    break;
                }
                case 2: {
                    if (this.length != 5) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.incorrectFrameSize());
                    }
                    if (this.streamId == 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustNotBeZeroForFrameType(2));
                    }
                    this.parser = new Http2PriorityParser(this.length);
                    break;
                }
                default: {
                    this.parser = new Http2DiscardParser(this.length);
                }
            }
        }
        this.parser.parse(byteBuffer, this);
        if (this.continuationParser != null && Bits.anyAreSet(this.flags, 4)) {
            this.continuationParser = null;
        }
        return this.parser.isFinished();
    }

    private boolean parseFrameHeader(ByteBuffer byteBuffer) {
        while (this.read < 9 && byteBuffer.hasRemaining()) {
            this.header[this.read++] = byteBuffer.get();
        }
        if (this.read != 9) {
            return false;
        }
        this.length = (this.header[0] & 0xFF) << 16;
        this.length += (this.header[1] & 0xFF) << 8;
        this.length += this.header[2] & 0xFF;
        this.type = this.header[3] & 0xFF;
        this.flags = this.header[4] & 0xFF;
        this.streamId = (this.header[5] & 0xFFFFFF7F & 0xFF) << 24;
        this.streamId += (this.header[6] & 0xFF) << 16;
        this.streamId += (this.header[7] & 0xFF) << 8;
        this.streamId += this.header[8] & 0xFF;
        return true;
    }

    @Override
    public long getFrameLength() {
        if (this.type != 0) {
            return 0L;
        }
        return this.length;
    }

    int getActualLength() {
        return this.length;
    }

    @Override
    public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
        if (this.type == 0 || this.type == 9 || this.type == 2) {
            Http2StreamSourceChannel http2StreamSourceChannel;
            if (Bits.anyAreSet(this.flags, 1)) {
                http2StreamSourceChannel = this.http2Channel.removeStreamSource(this.streamId);
            } else if (this.type == 9) {
                http2StreamSourceChannel = this.http2Channel.getIncomingStream(this.streamId);
                if (http2StreamSourceChannel != null && http2StreamSourceChannel.isHeadersEndStream() && Bits.anyAreSet(this.flags, 4)) {
                    this.http2Channel.removeStreamSource(this.streamId);
                }
            } else {
                http2StreamSourceChannel = this.http2Channel.getIncomingStream(this.streamId);
            }
            if (this.type == 0 && http2StreamSourceChannel != null) {
                Http2DataFrameParser dataFrameParser = (Http2DataFrameParser)this.parser;
                http2StreamSourceChannel.updateContentSize(this.getFrameLength() - (long)dataFrameParser.getPadding(), Bits.anyAreSet(this.flags, 1));
            }
            return http2StreamSourceChannel;
        }
        if (this.type == 1) {
            Http2StreamSourceChannel channel = this.http2Channel.getIncomingStream(this.streamId);
            if (channel != null) {
                if (Bits.anyAreClear(this.flags, 1) && !((Http2HeadersParser)this.parser).isContentExpected()) {
                    UndertowLogger.REQUEST_IO_LOGGER.debug("Received HTTP/2 trailers header without end stream set");
                    this.http2Channel.sendGoAway(1);
                }
                if (!channel.isHeadersEndStream() && Bits.allAreSet(this.flags, 5)) {
                    this.http2Channel.removeStreamSource(this.streamId);
                }
            }
            return channel;
        }
        return null;
    }

    Http2PushBackParser getParser() {
        return this.parser;
    }

    Http2HeadersParser getContinuationParser() {
        return this.continuationParser;
    }
}

