/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import java.util.List;
import libs.io.undertow.Handlers;
import libs.io.undertow.security.api.AuthenticationMechanism;
import libs.io.undertow.security.api.AuthenticationMechanismContext;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.ResponseCodeHandler;

public class AuthenticationMechanismsHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final AuthenticationMechanism[] authenticationMechanisms;

    public AuthenticationMechanismsHandler(HttpHandler next, List<AuthenticationMechanism> authenticationMechanisms) {
        this.next = next;
        this.authenticationMechanisms = authenticationMechanisms.toArray(new AuthenticationMechanism[authenticationMechanisms.size()]);
    }

    public AuthenticationMechanismsHandler(List<AuthenticationMechanism> authenticationHandlers) {
        this.authenticationMechanisms = authenticationHandlers.toArray(new AuthenticationMechanism[authenticationHandlers.size()]);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = exchange.getSecurityContext();
        if (sc != null && sc instanceof AuthenticationMechanismContext) {
            AuthenticationMechanismContext amc = (AuthenticationMechanismContext)sc;
            for (int i = 0; i < this.authenticationMechanisms.length; ++i) {
                amc.addAuthenticationMechanism(this.authenticationMechanisms[i]);
            }
        }
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public AuthenticationMechanismsHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

