/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server;

import java.io.IOException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.RenegotiationRequiredException;
import libs.org.xnio.SslClientAuthMode;

public interface SSLSessionInfo {
    public static int calculateKeySize(String cipherSuite) {
        if (cipherSuite == null) {
            return 0;
        }
        if (cipherSuite.equals("TLS_AES_256_GCM_SHA384")) {
            return 256;
        }
        if (cipherSuite.equals("TLS_CHACHA20_POLY1305_SHA256")) {
            return 256;
        }
        if (cipherSuite.startsWith("TLS_AES_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_AES_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_AES_256_")) {
            return 256;
        }
        if (cipherSuite.contains("WITH_3DES_EDE_CBC_")) {
            return 168;
        }
        if (cipherSuite.contains("WITH_RC4_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_DES_CBC_")) {
            return 56;
        }
        if (cipherSuite.contains("WITH_DES40_CBC_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_RC4_40_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_IDEA_CBC_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_RC2_CBC_40_")) {
            return 40;
        }
        return 0;
    }

    public byte[] getSessionId();

    public String getCipherSuite();

    default public int getKeySize() {
        return SSLSessionInfo.calculateKeySize(this.getCipherSuite());
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException;

    @Deprecated(since="2.2.3", forRemoval=false)
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException;

    public void renegotiate(HttpServerExchange var1, SslClientAuthMode var2) throws IOException;

    public SSLSession getSSLSession();
}

