/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.form;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.Handlers;
import libs.io.undertow.server.HandlerWrapper;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.ResponseCodeHandler;
import libs.io.undertow.server.handlers.builder.HandlerBuilder;
import libs.io.undertow.server.handlers.form.FormDataParser;
import libs.io.undertow.server.handlers.form.FormParserFactory;

public class EagerFormParsingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final FormParserFactory formParserFactory;
    public static final HandlerWrapper WRAPPER = new HandlerWrapper(){

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new EagerFormParsingHandler(handler);
        }
    };

    public EagerFormParsingHandler(FormParserFactory formParserFactory) {
        this.formParserFactory = formParserFactory;
    }

    public EagerFormParsingHandler() {
        this.formParserFactory = FormParserFactory.builder().build();
    }

    public EagerFormParsingHandler(HttpHandler next) {
        this();
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isBlocking()) {
            exchange.putAttachment(FormDataParser.FORM_DATA, parser.parseBlocking());
            this.next.handleRequest(exchange);
        } else {
            parser.parse(this.next);
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EagerFormParsingHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public String toString() {
        return "eager-form-parser()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "eager-form-parser";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return WRAPPER;
        }
    }
}

