/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.util.ObjectPool;
import libs.io.undertow.util.PooledObject;

public class NewInstanceObjectPool<T>
implements ObjectPool {
    private final Supplier<T> supplier;
    private final Consumer<T> consumer;

    public NewInstanceObjectPool(Supplier<T> supplier, Consumer<T> consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
    }

    public PooledObject allocate() {
        final T obj = this.supplier.get();
        return new PooledObject(){
            private volatile boolean closed = false;

            @Override
            public T getObject() {
                if (this.closed) {
                    throw UndertowMessages.MESSAGES.objectIsClosed();
                }
                return obj;
            }

            @Override
            public void close() {
                this.closed = true;
                NewInstanceObjectPool.this.consumer.accept(obj);
            }
        };
    }
}

