/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import libs.io.undertow.UndertowLogger;
import libs.org.xnio.XnioExecutor;
import libs.org.xnio.XnioIoThread;

public class WorkerUtils {
    private WorkerUtils() {
    }

    public static XnioExecutor.Key executeAfter(XnioIoThread thread, Runnable task, long timeout, TimeUnit timeUnit) {
        try {
            return thread.executeAfter(task, timeout, timeUnit);
        }
        catch (RejectedExecutionException e) {
            if (thread.getWorker().isShutdown()) {
                UndertowLogger.ROOT_LOGGER.debugf((Throwable)e, "Failed to schedule task %s as worker is shutting down", (Object)task);
                return new XnioExecutor.Key(){

                    @Override
                    public boolean remove() {
                        return false;
                    }
                };
            }
            throw e;
        }
    }
}

