/*
 * Decompiled with CFR 0.152.
 */
package libs.net.querz.nbt.io;

import libs.net.querz.nbt.io.ParseException;

public class StringPointer {
    private String value;
    private int index;

    public StringPointer(String value) {
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public int size() {
        return this.value.length();
    }

    public String parseSimpleString() {
        int oldIndex = this.index;
        while (this.hasNext() && StringPointer.isSimpleChar(this.currentChar())) {
            ++this.index;
        }
        return this.value.substring(oldIndex, this.index);
    }

    public String parseQuotedString() throws ParseException {
        int oldIndex = ++this.index;
        StringBuilder sb = null;
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.next();
            if (escape) {
                if (c != '\\' && c != '\"') {
                    throw this.parseException("invalid escape of '" + c + "'");
                }
                escape = false;
            } else {
                if (c == '\\') {
                    escape = true;
                    if (sb != null) continue;
                    sb = new StringBuilder(this.value.substring(oldIndex, this.index - 1));
                    continue;
                }
                if (c == '\"') {
                    return sb == null ? this.value.substring(oldIndex, this.index - 1) : sb.toString();
                }
            }
            if (sb == null) continue;
            sb.append(c);
        }
        throw this.parseException("missing end quote");
    }

    public boolean nextArrayElement() {
        this.skipWhitespace();
        if (this.hasNext() && this.currentChar() == ',') {
            ++this.index;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    public void expectChar(char c) throws ParseException {
        this.skipWhitespace();
        boolean hasNext = this.hasNext();
        if (hasNext && this.currentChar() == c) {
            ++this.index;
            return;
        }
        throw this.parseException("expected '" + c + "' but got " + (hasNext ? "'" + this.currentChar() + "'" : "EOF"));
    }

    public void skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    public boolean hasNext() {
        return this.index < this.value.length();
    }

    public boolean hasCharsLeft(int num) {
        return this.index + num < this.value.length();
    }

    public char currentChar() {
        return this.value.charAt(this.index);
    }

    public char next() {
        return this.value.charAt(this.index++);
    }

    public void skip(int offset) {
        this.index += offset;
    }

    public char lookAhead(int offset) {
        return this.value.charAt(this.index + offset);
    }

    private static boolean isSimpleChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '+' || c == '.' || c == '_';
    }

    public ParseException parseException(String msg) {
        return new ParseException(msg, this.value, this.index);
    }
}

