/*
 * Decompiled with CFR 0.152.
 */
package libs.org.jboss.logging;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import libs.org.jboss.logging.JBossLogManagerLogger;
import libs.org.jboss.logging.Logger;
import libs.org.jboss.logging.LoggerProvider;
import libs.org.jboss.logmanager.LogContext;
import libs.org.jboss.logmanager.Logger;
import libs.org.jboss.logmanager.MDC;
import libs.org.jboss.logmanager.NDC;

public final class JBossLogManagerProvider
implements LoggerProvider {
    private static final Logger.AttachmentKey<Logger> KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<ConcurrentMap<String, Logger>> LEGACY_KEY = new Logger.AttachmentKey();

    @Override
    public Logger getLogger(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(() -> {
                try {
                    return JBossLogManagerProvider.doGetLogger(name);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return JBossLogManagerProvider.doLegacyGetLogger(name);
                }
            });
        }
        try {
            return JBossLogManagerProvider.doGetLogger(name);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return JBossLogManagerProvider.doLegacyGetLogger(name);
        }
    }

    private static Logger doLegacyGetLogger(String name) {
        Logger l;
        ConcurrentMap appearing;
        libs.org.jboss.logmanager.Logger lmLogger = LogContext.getLogContext().getLogger("");
        ConcurrentMap<String, Logger> loggers = (ConcurrentHashMap)lmLogger.getAttachment(LEGACY_KEY);
        if (loggers == null && (appearing = (ConcurrentMap)lmLogger.attachIfAbsent(LEGACY_KEY, loggers = new ConcurrentHashMap())) != null) {
            loggers = appearing;
        }
        if ((l = (Logger)loggers.get(name)) != null) {
            return l;
        }
        libs.org.jboss.logmanager.Logger logger2 = libs.org.jboss.logmanager.Logger.getLogger((String)name);
        l = new JBossLogManagerLogger(name, logger2);
        Logger appearing2 = loggers.putIfAbsent(name, l);
        if (appearing2 == null) {
            return l;
        }
        return appearing2;
    }

    private static Logger doGetLogger(String name) {
        Logger l = (Logger)LogContext.getLogContext().getAttachment(name, KEY);
        if (l != null) {
            return l;
        }
        libs.org.jboss.logmanager.Logger logger2 = libs.org.jboss.logmanager.Logger.getLogger((String)name);
        Logger a = (Logger)logger2.attachIfAbsent(KEY, (Object)(l = new JBossLogManagerLogger(name, logger2)));
        if (a == null) {
            return l;
        }
        return a;
    }

    @Override
    public void clearMdc() {
        MDC.clear();
    }

    @Override
    public Object putMdc(String key, Object value) {
        return MDC.putObject((String)key, (Object)value);
    }

    @Override
    public Object getMdc(String key) {
        return MDC.getObject((String)key);
    }

    @Override
    public void removeMdc(String key) {
        MDC.removeObject((String)key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        return MDC.copyObject();
    }

    @Override
    public void clearNdc() {
        NDC.clear();
    }

    @Override
    public String getNdc() {
        return NDC.get();
    }

    @Override
    public int getNdcDepth() {
        return NDC.getDepth();
    }

    @Override
    public String popNdc() {
        return NDC.pop();
    }

    @Override
    public String peekNdc() {
        return NDC.get();
    }

    @Override
    public void pushNdc(String message) {
        NDC.push((String)message);
    }

    @Override
    public void setNdcMaxDepth(int maxDepth) {
        NDC.trimTo((int)maxDepth);
    }
}

