/*
 * Decompiled with CFR 0.152.
 */
package libs.org.simpleyaml.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libs.org.simpleyaml.utils.Validate;

public class DumperBus
extends Writer {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<Optional<String>> lineQueue;
    private final Dumper source;
    private StringBuffer lineBuffer;

    public DumperBus(Dumper source, int capacity) {
        Validate.notNull(source, "Source not provided");
        this.source = source;
        this.lineQueue = new ArrayBlockingQueue<Optional<String>>(capacity, true);
    }

    public DumperBus(Dumper source) {
        this(source, 100);
    }

    public void dump() throws IOException {
        this.lineBuffer = new StringBuffer();
        this.runThread(() -> {
            try {
                this.source.dump(this);
            }
            finally {
                this.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] str, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int last = offset + len - 1;
            if (last >= offset && last < str.length && str[last] == '\n') {
                --len;
                if (--last >= offset && str[last] == '\r') {
                    --len;
                }
                if (len > 0) {
                    this.lineBuffer.append(str, offset, len);
                }
                this.flush();
            } else {
                this.lineBuffer.append(str, offset, len);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.lineBuffer.length() > 0) {
            this.append(this.lineBuffer.toString());
        }
        this.lineBuffer.setLength(0);
    }

    private void append(String line) throws IOException {
        try {
            this.lineQueue.put(Optional.ofNullable(line));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String await() throws IOException {
        try {
            if (this.lineQueue.isEmpty() && this.isClosed()) {
                return null;
            }
            return this.lineQueue.take().orElse(null);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this.flush();
            this.lineBuffer = null;
            this.append(null);
        }
        this.executor.shutdown();
    }

    protected boolean isClosed() {
        return this.lineBuffer == null;
    }

    public Dumper source() {
        return this.source;
    }

    protected void runThread(Task task) throws IOException {
        try {
            this.executor.submit(() -> {
                task.run();
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @FunctionalInterface
    private static interface Task {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface Dumper {
        public void dump(Writer var1) throws IOException;
    }
}

