/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common._private;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Permission;
import java.security.PrivilegedActionException;
import libs.org.jboss.logging.Messages;
import libs.org.jboss.logging.annotations.Cause;
import libs.org.jboss.logging.annotations.Message;
import libs.org.jboss.logging.annotations.MessageBundle;
import libs.org.wildfly.common.codec.DecodeException;

@MessageBundle(projectCode="COM", length=5)
public interface CommonMessages {
    public static final CommonMessages msg = Messages.getBundle(MethodHandles.lookup(), CommonMessages.class);

    @Message(id=0, value="Parameter '%s' may not be null")
    public IllegalArgumentException nullParam(String var1);

    @Message(id=1, value="Parameter '%s' must not be less than %d")
    public IllegalArgumentException paramLessThan(String var1, long var2);

    public IllegalArgumentException paramLessThan(String var1, double var2);

    @Message(id=2, value="Parameter '%s' must not be greater than than %d")
    public IllegalArgumentException paramGreaterThan(String var1, long var2);

    public IllegalArgumentException paramGreaterThan(String var1, double var2);

    @Message(id=3, value="Given offset of %d is greater than array length of %d")
    public ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(int var1, int var2);

    @Message(id=4, value="Given offset of %d plus length of %d is greater than array length of %d")
    public ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(int var1, int var2, int var3);

    @Message(id=5, value="Array index %d of parameter '%s' may not be null")
    public IllegalArgumentException nullArrayParam(int var1, String var2);

    @Message(id=6, value="Parameter '%s' may not be null")
    public NullPointerException nullParamNPE(String var1);

    @Message(id=7, value="Invalid permission action '%s'")
    public IllegalArgumentException invalidPermissionAction(String var1);

    @Message(id=8, value="Parameter '%s' must not be empty")
    public IllegalArgumentException emptyParam(String var1);

    @Message(id=9, value="Invalid expression syntax at position %d")
    public String invalidExpressionSyntax(int var1);

    @Message(id=10, value="No environment property found named \"%s\"")
    public IllegalArgumentException unresolvedEnvironmentProperty(String var1);

    @Message(id=11, value="No system property found named \"%s\"")
    public IllegalArgumentException unresolvedSystemProperty(String var1);

    @Message(id=12, value="Invalid address length of %d; must be 4 or 16")
    public IllegalArgumentException invalidAddressBytes(int var1);

    @Message(id=13, value="Invalid address string \"%s\"")
    public IllegalArgumentException invalidAddress(String var1);

    @Message(id=100, value="Method \"%s\" of class \"%s\" is not implemented")
    public UnsupportedOperationException unsupported(String var1, String var2);

    @Message(id=200, value="Privileged action failed")
    public PrivilegedActionException privilegedActionFailed(@Cause Exception var1);

    @Message(id=300, value="Permission collection is read-only")
    public SecurityException readOnlyPermissionCollection();

    @Message(id=301, value="Invalid permission type (expected %s, actual value was %s)")
    public IllegalArgumentException invalidPermissionType(Class<? extends Permission> var1, Class<? extends Permission> var2);

    @Message(id=400, value="Invalid serialized remote exception cause object with odd number of strings in fields key/value list")
    public IllegalStateException invalidOddFields();

    @Message(id=401, value="Field name or field value cannot be null")
    public IllegalArgumentException cannotContainNullFieldNameOrValue();

    @Message(id=402, value="Remote exception stream is corrupted and cannot be read")
    public IOException corruptedStream();

    @Message(value="Remote exception %s: %s")
    public String remoteException(String var1, String var2);

    @Message(value="Remote exception %s")
    public String remoteException(String var1);

    @Message(id=500, value="Unexpected padding")
    public DecodeException unexpectedPadding();

    @Message(id=501, value="Expected padding")
    public DecodeException expectedPadding();

    @Message(id=502, value="Incomplete decode")
    public DecodeException incompleteDecode();

    @Message(id=503, value="Expected %d padding characters")
    public DecodeException expectedPaddingCharacters(int var1);

    @Message(id=504, value="Invalid base 32 character")
    public DecodeException invalidBase32Character();

    @Message(id=505, value="Expected an even number of hex characters")
    public DecodeException expectedEvenNumberOfHexCharacters();

    @Message(id=506, value="Invalid hex character")
    public DecodeException invalidHexCharacter();

    @Message(id=507, value="Expected two padding characters")
    public DecodeException expectedTwoPaddingCharacters();

    @Message(id=508, value="Invalid base 64 character")
    public DecodeException invalidBase64Character();

    @Message(id=509, value="Byte string builder is too large to grow")
    public IllegalStateException tooLarge();

    @Message(id=1000, value="Internal error: Assertion failure: Unexpectedly null value")
    public String unexpectedNullValue();

    @Message(id=1001, value="Internal error: Assertion failure: Current thread expected to hold lock for %s")
    public String expectedLockHold(Object var1);

    @Message(id=1002, value="Internal error: Assertion failure: Current thread expected to not hold lock for %s")
    public String expectedLockNotHold(Object var1);

    @Message(id=1003, value="Internal error: Assertion failure: Expected boolean value to be %s")
    public String expectedBoolean(boolean var1);

    @Message(id=2000, value="Internal error: Unreachable code has been reached")
    public IllegalStateException unreachableCode();

    @Message(id=2001, value="Internal error: Impossible switch condition encountered: %s")
    public IllegalStateException impossibleSwitchCase(Object var1);
}

