/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class ObjectProperties
extends Hashtable<String, String> {
    private static final long serialVersionUID = -4691081844415343670L;
    private final Map<String, String> realMap;

    public static Property property(String key, String value) {
        return new Property(key, value);
    }

    public static ObjectProperties properties(Property ... properties) {
        return new ObjectProperties(properties);
    }

    public ObjectProperties(int initialCapacity, float loadFactor) {
        this.realMap = new LinkedHashMap<String, String>(initialCapacity, loadFactor);
    }

    public ObjectProperties(int initialCapacity) {
        this.realMap = new LinkedHashMap<String, String>(initialCapacity);
    }

    public ObjectProperties() {
        this.realMap = new LinkedHashMap<String, String>();
    }

    public ObjectProperties(Map<? extends String, ? extends String> t) {
        this.realMap = new LinkedHashMap<String, String>(t);
    }

    public ObjectProperties(Property ... properties) {
        this.realMap = new LinkedHashMap<String, String>(properties.length);
        for (Property property : properties) {
            this.realMap.put(property.getKey(), property.getValue());
        }
    }

    @Override
    public int size() {
        return this.realMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.realMap.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return Collections.enumeration(this.realMap.keySet());
    }

    @Override
    public Enumeration<String> elements() {
        return Collections.enumeration(this.realMap.values());
    }

    @Override
    public boolean contains(Object value) {
        return this.realMap.containsValue(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.realMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.realMap.containsKey(key);
    }

    @Override
    public String get(Object key) {
        return this.realMap.get(key);
    }

    @Override
    protected void rehash() {
    }

    @Override
    public String put(String key, String value) {
        return this.realMap.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.realMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        this.realMap.putAll(t);
    }

    @Override
    public void clear() {
        this.realMap.clear();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public String toString() {
        return this.realMap.toString();
    }

    @Override
    public Set<String> keySet() {
        return this.realMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.realMap.entrySet();
    }

    @Override
    public Collection<String> values() {
        return this.realMap.values();
    }

    public static final class Property {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("key is null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

