/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import io.leangen.geantyref.TypeToken;
import net.pl3x.map.bukkit.command.BukkitParsers;
import net.pl3x.map.bukkit.command.BukkitSender;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.parser.PlatformParsers;
import net.pl3x.map.core.command.parser.WorldParser;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.Command;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BukkitCommandManager
implements CommandHandler {
    private final LegacyPaperCommandManager<Sender> manager;
    private final Command.Builder<Sender> root;

    public BukkitCommandManager(Plugin plugin) throws Exception {
        this.manager = new LegacyPaperCommandManager<Sender>(plugin, ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(BukkitSender::create, Sender::getSender));
        if (this.getManager().hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            ((LegacyPaperCommandManager)this.getManager()).registerBrigadier();
            CloudBrigadierManager brigadier = ((LegacyPaperCommandManager)this.getManager()).brigadierManager();
            if (brigadier != null) {
                brigadier.setNativeNumberSuggestions(false);
                brigadier.registerMapping(new TypeToken<WorldParser<Sender>>(this){}, builder -> builder.cloudSuggestions().toConstant((ArgumentType<?>)StringArgumentType.string()));
            }
        } else if (this.getManager().hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            ((LegacyPaperCommandManager)this.getManager()).registerAsynchronousCompletions();
        }
        this.setupExceptionHandlers();
        this.root = this.buildRoot();
        this.getManager().command(this.getRoot());
        this.registerSubcommands();
    }

    public LegacyPaperCommandManager<Sender> getManager() {
        return this.manager;
    }

    @Override
    public PlatformParsers getPlatformParsers() {
        return new BukkitParsers();
    }

    @Override
    public Command.Builder<Sender> getRoot() {
        return this.root;
    }
}

