/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.parser.WorldParser;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FullRenderCommand
extends Pl3xMapCommand {
    public FullRenderCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("fullrender", new String[0]).required("world", WorldParser.parser(), (Description)FullRenderCommand.description(Lang.COMMAND_ARGUMENT_REQUIRED_WORLD_DESCRIPTION, new TagResolver.Single[0])).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_FULLRENDER_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.fullrender").handler(this::execute));
    }

    public void execute(CommandContext<Sender> context) {
        CompletableFuture.runAsync(() -> this.executeAsync(context));
    }

    private void executeAsync(CommandContext<Sender> context) {
        Sender sender = context.sender();
        World world = (World)context.get("world");
        Collection<Point> regions = world.listRegions(true);
        if (Config.DEBUG_MODE) {
            regions.forEach(region -> Logger.debug("Adding region: " + String.valueOf(region)));
        }
        Pl3xMap.api().getRegionProcessor().addRegions(world, regions);
        if (regions.isEmpty()) {
            TagResolver.Single worldPlaceholder = Placeholder.unparsed("world", world.getName());
            sender.sendMessage(Lang.COMMAND_FULLRENDER_NO_REGION_FILES_FOUND, worldPlaceholder);
        } else {
            sender.sendMessage(Lang.COMMAND_FULLRENDER_STARTING);
        }
    }
}

