/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.parser.WorldParser;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RadiusRenderCommand
extends Pl3xMapCommand {
    public RadiusRenderCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("radiusrender", new String[0]).required("world", WorldParser.parser(), (Description)RadiusRenderCommand.description(Lang.COMMAND_ARGUMENT_REQUIRED_WORLD_DESCRIPTION, new TagResolver.Single[0])).required("radius", IntegerParser.integerParser(1, 1000000)).optional("center", this.getHandler().getPlatformParsers().columnPosParser(), (Description)RadiusRenderCommand.description(Lang.COMMAND_ARGUMENT_OPTIONAL_CENTER_DESCRIPTION, new TagResolver.Single[0])).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_RADIUSRENDER_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.radiusrender").handler(this::execute));
    }

    public void execute(CommandContext<Sender> context) {
        CompletableFuture.runAsync(() -> this.executeAsync(context));
    }

    private void executeAsync(CommandContext<Sender> context) {
        Sender sender = context.sender();
        World world = (World)context.get("world");
        int radius = (Integer)context.get("radius");
        Point center = this.getHandler().getPlatformParsers().resolvePointFromColumnPos("center", context);
        int rX = center.x() >> 9;
        int rZ = center.z() >> 9;
        int rR = radius >> 9;
        int minX = rX - rR;
        int minZ = rZ - rR;
        int maxX = rX + rR;
        int maxZ = rZ + rR;
        Collection<Point> regions = world.listRegions(true);
        regions.removeIf(region -> region.x() < minX || region.z() < minZ || region.x() > maxX || region.z() > maxZ);
        if (Config.DEBUG_MODE) {
            regions.forEach(region -> Logger.debug("Adding region: " + String.valueOf(region)));
        }
        Pl3xMap.api().getRegionProcessor().addRegions(world, regions);
        sender.sendMessage(Lang.COMMAND_RADIUSRENDER_STARTING);
    }
}

