/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.parser;

import java.util.stream.Collectors;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.exception.WorldParseException;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WorldParser<C>
implements ArgumentParser<C, World>,
BlockingSuggestionProvider.Strings<C> {
    public static <C> ParserDescriptor<C, World> parser() {
        return ParserDescriptor.of(new WorldParser<C>(), World.class);
    }

    @Override
    public ArgumentParseResult<World> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        if (input.startsWith("\"")) {
            commandInput.moveCursor(1);
            input = commandInput.readUntilAndSkip('\"');
        } else {
            input = commandInput.readString();
        }
        if (input == null) {
            return ArgumentParseResult.failure(new WorldParseException(null, WorldParseException.MUST_SPECIFY_WORLD));
        }
        World world = null;
        try {
            world = (World)Pl3xMap.api().getWorldRegistry().get(input);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParseException(input, WorldParseException.NO_SUCH_WORLD));
        }
        if (!world.isEnabled()) {
            return ArgumentParseResult.failure(new WorldParseException(input, WorldParseException.MAP_NOT_ENABLED));
        }
        return ArgumentParseResult.success(world);
    }

    public static World resolveWorld(CommandContext<Sender> context, String name) {
        Sender sender = context.sender();
        World world = context.getOrDefault(name, null);
        if (world != null) {
            return world;
        }
        if (sender instanceof Sender.Player) {
            Sender.Player player = (Sender.Player)((Object)sender);
            world = player.getWorld();
            if (world == null) {
                throw new WorldParseException("unknown", WorldParseException.NO_SUCH_WORLD);
            }
            if (!world.isEnabled()) {
                throw new WorldParseException(world.getName(), WorldParseException.MAP_NOT_ENABLED);
            }
            return world;
        }
        throw new WorldParseException(null, WorldParseException.MUST_SPECIFY_WORLD);
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput input) {
        return Pl3xMap.api().getWorldRegistry().values().stream().filter(World::isEnabled).map(world -> world.getName().contains(" ") ? "\"" + world.getName() + "\"" : world.getName()).collect(Collectors.toList());
    }
}

