/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.configuration;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import libs.org.simpleyaml.configuration.comments.CommentType;
import libs.org.simpleyaml.configuration.file.YamlFile;
import libs.org.simpleyaml.exceptions.InvalidConfigurationException;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.util.StringUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class AbstractConfig {
    private YamlFile config;

    public YamlFile getConfig() {
        return this.config;
    }

    protected void reload(Path path, Class<? extends AbstractConfig> clazz) {
        this.config = new YamlFile(path.toFile());
        try {
            this.getConfig().createOrLoadWithComments();
        }
        catch (InvalidConfigurationException e) {
            Logger.severe("Could not load " + String.valueOf(path.getFileName()) + ", please correct your syntax errors", e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Arrays.stream(clazz.getDeclaredFields()).forEach(field -> {
            Key key = field.getDeclaredAnnotation(Key.class);
            Comment comment = field.getDeclaredAnnotation(Comment.class);
            if (key == null) {
                return;
            }
            try {
                Object object;
                Object obj = this.getClassObject();
                Object value = this.getValue(key.value(), field.get(obj));
                if (value instanceof String) {
                    String str = (String)value;
                    object = StringUtils.unescapeJava(str);
                } else {
                    object = value;
                }
                field.set(obj, object);
                if (comment != null) {
                    this.setComment(key.value(), comment.value());
                }
            }
            catch (Throwable e) {
                Logger.warn("Failed to load " + key.value() + " from " + path.getFileName().toString(), e);
            }
        });
        this.save();
    }

    protected void save() {
        try {
            this.getConfig().save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected @Nullable Object getClassObject() {
        return null;
    }

    protected @Nullable Object getValue(String path, @Nullable Object def) {
        if (this.getConfig().get(path) == null) {
            this.set(path, def);
        }
        return this.get(path, def);
    }

    protected void setComment(String path, @Nullable String comment) {
        this.getConfig().setComment(path, comment, CommentType.BLOCK);
    }

    protected @Nullable Object get(String path, @Nullable Object def) {
        Object val = this.get(path);
        return val == null ? def : val;
    }

    protected @Nullable Object get(String path) {
        Object value = this.getConfig().get(path);
        if (!(value instanceof ConfigurationSection)) {
            return value;
        }
        ConfigurationSection section = (ConfigurationSection)value;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            String rawValue = section.getString(key);
            if (rawValue == null) continue;
            map.put(key, this.addToMap(rawValue));
        }
        return map;
    }

    protected Object addToMap(String rawValue) {
        return rawValue;
    }

    protected void set(String path, @Nullable Object value) {
        this.getConfig().set(path, value);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Key {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String value();
    }
}

