/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.log;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.log.LogFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Logger {
    public static void debug(String message) {
        if (Config.DEBUG_MODE) {
            Logger.log("<gray>[<yellow>DEBUG</yellow>] " + message);
        }
    }

    public static void info(String message) {
        Logger.log("<gray>[INFO] " + message);
    }

    public static void severe(String message) {
        Logger.severe(message, null);
    }

    public static void severe(String message, @Nullable Throwable throwable) {
        Logger.log("<gray>[<red>ERROR</red>]</gray> <red>" + message);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static void warn(String message) {
        Logger.warn(message, null);
    }

    public static void warn(String message, @Nullable Throwable throwable) {
        Logger.log("<gray>[<yellow>WARN</yellow>]</gray> <yellow>" + message);
        if (throwable != null && Config.DEBUG_MODE) {
            throwable.printStackTrace();
        }
    }

    private static void log(String message) {
        if (Pl3xMap.api().isEnabled()) {
            Pl3xMap.api().adventure().console().sendMessage(Lang.parse(Lang.PREFIX_COMMAND + message, new TagResolver.Single[0]));
        } else {
            System.out.println(Lang.strip(Lang.PREFIX_COMMAND + message));
        }
    }

    static {
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addFilter((Filter)new LogFilter());
    }
}

