/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers;

import com.google.gson.JsonObject;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.JsonSerializable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record Point(int x, int z) implements JsonSerializable
{
    public static final Point ZERO = new Point(0, 0);

    public static Point of(int x, int z) {
        return new Point(x, z);
    }

    public static Point of(double x, double z) {
        return Point.of((int)Math.floor(x), (int)Math.floor(z));
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("x", this.x());
        wrapper.addProperty("z", this.z());
        return wrapper.getJsonObject();
    }

    public static Point fromJson(JsonObject obj) {
        return Point.of(obj.get("x").getAsInt(), obj.get("z").getAsInt());
    }
}

