/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.markers.marker.Marker;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SimpleLayer
extends Layer {
    private final Map<String, Marker<?>> markers = new ConcurrentHashMap();

    public SimpleLayer(String key, Supplier<String> labelSupplier) {
        super(key, labelSupplier);
    }

    @Override
    public Collection<Marker<?>> getMarkers() {
        return this.markers.values();
    }

    public SimpleLayer addMarker(Marker<?> marker) {
        this.markers.put(marker.getKey(), marker);
        return this;
    }

    public @Nullable Marker<?> removeMarker(String key) {
        return this.markers.remove(key);
    }

    public SimpleLayer clearMarkers() {
        this.markers.clear();
        return this;
    }

    public Map<String, Marker<?>> registeredMarkers() {
        return Collections.unmodifiableMap(this.markers);
    }

    public boolean hasMarker(String key) {
        return this.markers.containsKey(key);
    }
}

