/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Circle
extends Marker<Circle> {
    private Point center;
    private double radius;

    private Circle(String key) {
        super("circ", key);
    }

    public Circle(String key, double centerX, double centerZ, double radius) {
        this(key);
        this.setCenter(Point.of(centerX, centerZ));
        this.setRadius(radius);
    }

    public Circle(String key, Point center, double radius) {
        this(key);
        this.setCenter(center);
        this.setRadius(radius);
    }

    public static Circle of(String key, double centerX, double centerZ, double radius) {
        return new Circle(key, centerX, centerZ, radius);
    }

    public static Circle of(String key, Point center, double radius) {
        return new Circle(key, center, radius);
    }

    public Point getCenter() {
        return this.center;
    }

    public Circle setCenter(Point center) {
        this.center = Preconditions.checkNotNull(center, "Circle center is null");
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public Circle setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("center", this.getCenter());
        wrapper.addProperty("radius", this.getRadius());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Circle fromJson(JsonObject obj) {
        Circle circle = Circle.of(obj.get("key").getAsString(), Point.fromJson((JsonObject)obj.get("center")), obj.get("radius").getAsInt());
        JsonElement el = obj.get("pane");
        if (el != null && !(el instanceof JsonNull)) {
            circle.setPane(el.getAsString());
        }
        return circle;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Circle other = (Circle)o;
        return this.getKey().equals(other.getKey()) && Objects.equals(this.getCenter(), other.getCenter()) && Double.compare(this.getRadius(), other.getRadius()) == 0 && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getCenter(), this.getRadius(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Circle{key=" + this.getKey() + ",center=" + String.valueOf(this.getCenter()) + ",radius=" + this.getRadius() + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

