/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.option.Option;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Fill
extends Option<Fill> {
    private Boolean enabled;
    private Type type;
    private Integer color;

    public Fill() {
    }

    public Fill(boolean enabled) {
        this.setEnabled(enabled);
    }

    public Fill(int color) {
        this.setColor(color);
    }

    public @Nullable Boolean isEnabled() {
        return this.enabled;
    }

    public Fill setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public @Nullable Type getType() {
        return this.type;
    }

    public Fill setType(@Nullable Type type) {
        this.type = type;
        return this;
    }

    public @Nullable Integer getColor() {
        return this.color;
    }

    public Fill setColor(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isDefault() {
        return !(this.isEnabled() != null && !Boolean.TRUE.equals(this.isEnabled()) || this.getType() != null && this.getType() != Type.EVENODD || this.getColor() != null);
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("enabled", this.isEnabled());
        wrapper.addProperty("type", this.getType());
        wrapper.addProperty("color", this.getColor());
        return wrapper.getJsonObject();
    }

    public static Fill fromJson(JsonObject obj) {
        Fill fill = new Fill();
        JsonElement el = obj.get("enabled");
        if (el != null && !(el instanceof JsonNull)) {
            fill.setEnabled(el.getAsBoolean());
        }
        if ((el = obj.get("type")) != null && !(el instanceof JsonNull)) {
            fill.setType(Type.values()[el.getAsInt()]);
        }
        if ((el = obj.get("color")) != null && !(el instanceof JsonNull)) {
            fill.setColor(el.getAsInt());
        }
        return fill;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Fill other = (Fill)o;
        return Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals((Object)this.getType(), (Object)other.getType()) && Objects.equals(this.getColor(), other.getColor());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled(), this.getType(), this.getColor()});
    }

    public String toString() {
        return "Fill{enabled=" + this.isEnabled() + ",type=" + String.valueOf((Object)this.getType()) + ",color=" + this.getColor() + "}";
    }

    public static enum Type {
        NONZERO,
        EVENODD;

    }
}

