/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.option.Option;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Popup
extends Option<Popup> {
    public static final Point DEFAULT_OFFSET = Point.of(0, 7);
    public static final Point DEFAULT_AUTO_PAN_PADDING = Point.of(5, 5);
    private String content;
    private String pane;
    private Point offset;
    private Integer maxWidth;
    private Integer minWidth;
    private Integer maxHeight;
    private Boolean autoPan;
    private Point autoPanPaddingTopLeft;
    private Point autoPanPaddingBottomRight;
    private Point autoPanPadding;
    private Boolean keepInView;
    private Boolean closeButton;
    private Boolean autoClose;
    private Boolean closeOnEscapeKey;
    private Boolean closeOnClick;

    public Popup() {
    }

    public Popup(@Nullable String content) {
        this.setContent(content);
    }

    public @Nullable String getContent() {
        return this.content;
    }

    public Popup setContent(@Nullable String content) {
        this.content = content;
        return this;
    }

    public @Nullable String getPane() {
        return this.pane;
    }

    public Popup setPane(@Nullable String pane) {
        this.pane = pane;
        return this;
    }

    public @Nullable Point getOffset() {
        return this.offset;
    }

    public Popup setOffset(@Nullable Point offset) {
        this.offset = offset;
        return this;
    }

    public @Nullable Integer getMaxWidth() {
        return this.maxWidth;
    }

    public Popup setMaxWidth(@Nullable Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public @Nullable Integer getMinWidth() {
        return this.minWidth;
    }

    public Popup setMinWidth(@Nullable Integer minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public @Nullable Integer getMaxHeight() {
        return this.maxHeight;
    }

    public Popup setMaxHeight(@Nullable Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public @Nullable Boolean shouldAutoPan() {
        return this.autoPan;
    }

    public Popup setShouldAutoPan(@Nullable Boolean autoPan) {
        this.autoPan = autoPan;
        return this;
    }

    public @Nullable Point getAutoPanPaddingTopLeft() {
        return this.autoPanPaddingTopLeft;
    }

    public Popup setAutoPanPaddingTopLeft(@Nullable Point autoPanPaddingTopLeft) {
        this.autoPanPaddingTopLeft = autoPanPaddingTopLeft;
        return this;
    }

    public @Nullable Point getAutoPanPaddingBottomRight() {
        return this.autoPanPaddingBottomRight;
    }

    public Popup setAutoPanPaddingBottomRight(@Nullable Point autoPanPaddingBottomRight) {
        this.autoPanPaddingBottomRight = autoPanPaddingBottomRight;
        return this;
    }

    public @Nullable Point getAutoPanPadding() {
        return this.autoPanPadding;
    }

    public Popup setAutoPanPadding(@Nullable Point autoPanPadding) {
        this.autoPanPadding = autoPanPadding;
        return this;
    }

    public @Nullable Boolean shouldKeepInView() {
        return this.keepInView;
    }

    public Popup setShouldKeepInView(@Nullable Boolean keepInView) {
        this.keepInView = keepInView;
        return this;
    }

    public @Nullable Boolean hasCloseButton() {
        return this.closeButton;
    }

    public Popup setCloseButton(@Nullable Boolean closeButton) {
        this.closeButton = closeButton;
        return this;
    }

    public @Nullable Boolean shouldAutoClose() {
        return this.autoClose;
    }

    public Popup setShouldAutoClose(@Nullable Boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public @Nullable Boolean shouldCloseOnEscapeKey() {
        return this.closeOnEscapeKey;
    }

    public Popup setShouldCloseOnEscapeKey(@Nullable Boolean closeOnEscapeKey) {
        this.closeOnEscapeKey = closeOnEscapeKey;
        return this;
    }

    public @Nullable Boolean shouldCloseOnClick() {
        return this.closeOnClick;
    }

    public Popup setShouldCloseOnClick(@Nullable Boolean closeOnClick) {
        this.closeOnClick = closeOnClick;
        return this;
    }

    @Override
    public boolean isDefault() {
        return !(this.getContent() != null || this.getPane() != null && !this.getPane().equals("popupPane") || this.getOffset() != null && !this.getOffset().equals(DEFAULT_OFFSET) || !this.isSizeDefault() || !this.isPanningDefault() || !this.isClosingDefault());
    }

    private boolean isSizeDefault() {
        return !(this.getMaxWidth() != null && this.getMaxWidth() != 300 || this.getMinWidth() != null && this.getMinWidth() != 50 || this.getMaxHeight() != null);
    }

    private boolean isPanningDefault() {
        return !(this.shouldAutoPan() != null && !Boolean.TRUE.equals(this.shouldAutoPan()) || this.getAutoPanPaddingTopLeft() != null || this.getAutoPanPaddingBottomRight() != null || this.getAutoPanPadding() != null && !this.getAutoPanPadding().equals(DEFAULT_AUTO_PAN_PADDING) || this.shouldKeepInView() != null && !Boolean.FALSE.equals(this.shouldKeepInView()));
    }

    private boolean isClosingDefault() {
        return !(this.hasCloseButton() != null && !Boolean.TRUE.equals(this.hasCloseButton()) || this.shouldAutoClose() != null && !Boolean.TRUE.equals(this.shouldAutoClose()) || this.shouldCloseOnEscapeKey() != null && !Boolean.TRUE.equals(this.shouldCloseOnEscapeKey()) || this.shouldCloseOnClick() != null && !Boolean.TRUE.equals(this.shouldCloseOnClick()));
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("content", this.getContent());
        wrapper.addProperty("pane", this.getPane());
        wrapper.addProperty("offset", this.getOffset());
        wrapper.addProperty("maxWidth", this.getMaxWidth());
        wrapper.addProperty("minWidth", this.getMinWidth());
        wrapper.addProperty("maxHeight", this.getMaxHeight());
        wrapper.addProperty("autoPan", this.shouldAutoPan());
        wrapper.addProperty("autoPanPaddingTopLeft", this.getAutoPanPaddingTopLeft());
        wrapper.addProperty("autoPanPaddingBottomRight", this.getAutoPanPaddingBottomRight());
        wrapper.addProperty("autoPanPadding", this.getAutoPanPadding());
        wrapper.addProperty("keepInView", this.shouldKeepInView());
        wrapper.addProperty("closeButton", this.hasCloseButton());
        wrapper.addProperty("autoClose", this.shouldAutoClose());
        wrapper.addProperty("closeOnEscapeKey", this.shouldCloseOnEscapeKey());
        wrapper.addProperty("closeOnClick", this.shouldCloseOnClick());
        return wrapper.getJsonObject();
    }

    public static Popup fromJson(JsonObject obj) {
        Popup popup = new Popup();
        JsonElement el = obj.get("content");
        if (el != null && !(el instanceof JsonNull)) {
            popup.setContent(el.getAsString());
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            popup.setPane(el.getAsString());
        }
        if ((el = obj.get("offset")) != null && !(el instanceof JsonNull)) {
            popup.setOffset(Point.fromJson((JsonObject)el));
        }
        Popup.fromJsonSize(obj, popup);
        Popup.fromJsonPanning(obj, popup);
        Popup.fromJsonClosing(obj, popup);
        return popup;
    }

    private static void fromJsonSize(JsonObject obj, Popup popup) {
        JsonElement el = obj.get("maxWidth");
        if (el != null && !(el instanceof JsonNull)) {
            popup.setMaxWidth(el.getAsInt());
        }
        if ((el = obj.get("minWidth")) != null && !(el instanceof JsonNull)) {
            popup.setMinWidth(el.getAsInt());
        }
        if ((el = obj.get("maxHeight")) != null && !(el instanceof JsonNull)) {
            popup.setMaxHeight(el.getAsInt());
        }
    }

    private static void fromJsonPanning(JsonObject obj, Popup popup) {
        JsonElement el = obj.get("autoPan");
        if (el != null && !(el instanceof JsonNull)) {
            popup.setShouldAutoPan(el.getAsBoolean());
        }
        if ((el = obj.get("autoPanPaddingTopLeft")) != null && !(el instanceof JsonNull)) {
            popup.setAutoPanPaddingTopLeft(Point.fromJson((JsonObject)el));
        }
        if ((el = obj.get("autoPanPaddingBottomRight")) != null && !(el instanceof JsonNull)) {
            popup.setAutoPanPaddingBottomRight(Point.fromJson((JsonObject)el));
        }
        if ((el = obj.get("autoPanPadding")) != null && !(el instanceof JsonNull)) {
            popup.setAutoPanPadding(Point.fromJson((JsonObject)el));
        }
        if ((el = obj.get("keepInView")) != null && !(el instanceof JsonNull)) {
            popup.setShouldKeepInView(el.getAsBoolean());
        }
    }

    private static void fromJsonClosing(JsonObject obj, Popup popup) {
        JsonElement el = obj.get("closeButton");
        if (el != null && !(el instanceof JsonNull)) {
            popup.setCloseButton(el.getAsBoolean());
        }
        if ((el = obj.get("autoClose")) != null && !(el instanceof JsonNull)) {
            popup.setShouldAutoClose(el.getAsBoolean());
        }
        if ((el = obj.get("closeOnEscapeKey")) != null && !(el instanceof JsonNull)) {
            popup.setShouldCloseOnEscapeKey(el.getAsBoolean());
        }
        if ((el = obj.get("closeOnClick")) != null && !(el instanceof JsonNull)) {
            popup.setShouldCloseOnClick(el.getAsBoolean());
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Popup other = (Popup)o;
        return Objects.equals(this.getContent(), other.getContent()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOffset(), other.getOffset()) && this.isSizeEqual(other) && this.isPanningEqual(other) && this.isClosingEqual(other);
    }

    private boolean isSizeEqual(Popup other) {
        return Objects.equals(this.getMaxWidth(), other.getMaxWidth()) && Objects.equals(this.getMinWidth(), other.getMinWidth()) && Objects.equals(this.getMaxHeight(), other.getMaxHeight());
    }

    private boolean isPanningEqual(Popup other) {
        return Objects.equals(this.shouldAutoPan(), other.shouldAutoPan()) && Objects.equals(this.getAutoPanPaddingTopLeft(), other.getAutoPanPaddingTopLeft()) && Objects.equals(this.getAutoPanPaddingBottomRight(), other.getAutoPanPaddingBottomRight()) && Objects.equals(this.getAutoPanPadding(), other.getAutoPanPadding()) && Objects.equals(this.shouldKeepInView(), other.shouldKeepInView());
    }

    private boolean isClosingEqual(Popup other) {
        return Objects.equals(this.hasCloseButton(), other.hasCloseButton()) && Objects.equals(this.shouldAutoClose(), other.shouldAutoClose()) && Objects.equals(this.shouldCloseOnEscapeKey(), other.shouldCloseOnEscapeKey()) && Objects.equals(this.shouldCloseOnClick(), other.shouldCloseOnClick());
    }

    public int hashCode() {
        return Objects.hash(this.getContent(), this.getPane(), this.getOffset(), this.getMaxWidth(), this.getMinWidth(), this.getMaxHeight(), this.shouldAutoPan(), this.getAutoPanPaddingTopLeft(), this.getAutoPanPaddingBottomRight(), this.getAutoPanPadding(), this.shouldKeepInView(), this.hasCloseButton(), this.shouldAutoClose(), this.shouldCloseOnEscapeKey(), this.shouldCloseOnClick());
    }

    public String toString() {
        return "Popup{,content=" + this.getContent() + ",pane=" + this.getPane() + ",offset=" + String.valueOf(this.getOffset()) + ",maxWidth=" + this.getMaxWidth() + ",minWidth=" + this.getMinWidth() + ",maxHeight=" + this.getMaxHeight() + ",autoPan=" + this.shouldAutoPan() + ",autoPanPaddingTopLeft=" + String.valueOf(this.getAutoPanPaddingTopLeft()) + ",autoPanPaddingBottomRight=" + String.valueOf(this.getAutoPanPaddingBottomRight()) + ",autoPanPadding=" + String.valueOf(this.getAutoPanPadding()) + ",keepInView=" + this.shouldKeepInView() + ",closeButton=" + this.hasCloseButton() + ",autoClose=" + this.shouldAutoClose() + ",closeOnEscapeKey=" + this.shouldCloseOnEscapeKey() + ",closeOnClick=" + this.shouldCloseOnClick() + "}";
    }
}

