/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.player;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Player
extends Keyed {
    private Object player;
    private Map<BiFunction<Player, String, String>, Integer> nameDecorators = new LinkedHashMap<BiFunction<Player, String, String>, Integer>();
    private boolean hidden;

    public <T> Player(String key, T player) {
        super(key);
        this.player = player;
    }

    public <T> T getPlayer() {
        return (T)this.player;
    }

    public void setPlayer(Object player) {
        this.player = player;
    }

    public abstract String getName();

    public abstract UUID getUUID();

    public abstract World getWorld();

    public abstract Point getPosition();

    public abstract float getYaw();

    public abstract int getHealth();

    public abstract int getArmorPoints();

    public abstract @Nullable URL getSkin();

    public abstract boolean isInvisible();

    public abstract boolean isNPC();

    public abstract boolean isSpectator();

    public boolean isHidden() {
        if (this.hidden) {
            return true;
        }
        return this.isPersistentlyHidden();
    }

    public void setHidden(boolean hidden, boolean persistent) {
        this.hidden = hidden;
        if (persistent) {
            this.setPersistentlyHidden(hidden);
        }
    }

    public abstract boolean isPersistentlyHidden();

    public abstract void setPersistentlyHidden(boolean var1);

    public void registerNameDecorator(int priority, BiFunction<Player, String, String> decorator) {
        this.nameDecorators.put(decorator, priority);
        this.nameDecorators = this.nameDecorators.entrySet().stream().sorted((k1, k2) -> -((Integer)k1.getValue()).compareTo((Integer)k2.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public String getDecoratedName() {
        String name = this.getName();
        for (BiFunction<Player, String, String> fn : this.nameDecorators.keySet()) {
            name = fn.apply(this, name);
        }
        return name;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Player other = (Player)o;
        return this.getPlayer() == other.getPlayer();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getUUID());
    }
}

