/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.Blocks;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BlockRegistry
extends Registry<Block> {
    private static final Gson GSON = new GsonBuilder().create();
    public static final int MAX_INDEX = 2047;
    private final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private int lastIndex = 0;

    public void init() {
        Path file = FileUtil.getTilesDir().resolve("blocks.gz");
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try {
            TypeToken<Map<Integer, String>> token = new TypeToken<Map<Integer, String>>(this){};
            this.indexMap.putAll(((Map)GSON.fromJson(FileUtil.readGzip(file), (TypeToken)token)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        }
        catch (FileNotFoundException token) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Integer> getIndexMap() {
        return this.indexMap;
    }

    private int getNextIndex(String id) {
        if (this.size() > 2047) {
            return -1;
        }
        int index = this.indexMap.getOrDefault(id, -1);
        if (index > -1) {
            return index;
        }
        while (true) {
            if (!this.indexMap.containsValue(this.lastIndex)) {
                this.indexMap.put(id, this.lastIndex);
                return this.lastIndex;
            }
            ++this.lastIndex;
        }
    }

    @Override
    public Block register(String id, int color) {
        Block block = (Block)super.get(id);
        if (block != null) {
            return block;
        }
        if (id.startsWith("minecraft:")) {
            Logger.warn("Registering unknown vanilla block " + id);
        }
        return this.register(id, new Block(this.getNextIndex(id), id, color));
    }

    @Override
    public Block get(String id) {
        return this.getOrDefault(id, Blocks.AIR);
    }

    public void saveToDisk() {
        HashMap map = new HashMap();
        this.values().forEach(block -> map.put(block.getIndex(), block.getKey()));
        try {
            FileUtil.saveGzip(GSON.toJson(map), FileUtil.getTilesDir().resolve("blocks.gz"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

