/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import java.util.function.Supplier;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.world.WorldUnloadedEvent;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WorldRegistry
extends Registry<World> {
    @Override
    public World getOrDefault(String id, Supplier<World> supplier) {
        World world = (World)this.get(id);
        if (world == null) {
            world = supplier.get();
            this.register(world.getName(), world);
        }
        return world;
    }

    @Override
    public @Nullable World unregister(String id) {
        World world = (World)this.entries.remove(id);
        if (world != null) {
            Pl3xMap.api().getEventRegistry().callEvent(new WorldUnloadedEvent(world));
            world.getMarkerTask().cancel();
            world.getLiveDataTask().cancel();
            world.cleanup();
        }
        return world;
    }
}

