/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import java.util.Arrays;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.heightmap.Heightmap;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.BlurTool;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class VintageStoryRenderer
extends Renderer {
    private final Heightmap heightmap = (Heightmap)Pl3xMap.api().getHeightmapRegistry().get("vintage_story");

    public VintageStoryRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public Heightmap getHeightmap() {
        return this.heightmap;
    }

    @Override
    public void scanData(Region region) {
        int[] pixelMap = new int[262144];
        byte[] shadowMap = new byte[262144];
        Arrays.fill(shadowMap, (byte)0);
        int cX = region.getX() << 5;
        int cZ = region.getZ() << 5;
        for (int chunkX = cX; chunkX < cX + 32; ++chunkX) {
            int bX = chunkX << 4;
            for (int chunkZ = cZ; chunkZ < cZ + 32; ++chunkZ) {
                if (!this.getWorld().visibleChunk(chunkX, chunkZ)) continue;
                int bZ = chunkZ << 4;
                Chunk chunk = region.getChunk(chunkX, chunkZ);
                for (int blockX = bX; blockX < bX + 16; ++blockX) {
                    for (int blockZ = bZ; blockZ < bZ + 16; ++blockZ) {
                        Chunk.BlockData data;
                        Pl3xMap.api().getRegionProcessor().checkPaused();
                        if (!this.getWorld().visibleBlock(blockX, blockZ) || (data = chunk.getData(blockX, blockZ)) == null) continue;
                        Biome biome = data.getBiome(region, blockX, blockZ);
                        int pixelColor = 0;
                        if ((data.getFluidState() == null || region.getWorld().getConfig().RENDER_TRANSLUCENT_FLUIDS) && (pixelColor = Colors.fixBlockColor(region, biome, data.getBlockState(), blockX, blockZ)) != 0) {
                            pixelColor = Colors.setAlpha(255, pixelColor);
                        }
                        pixelColor = this.processFluids(region.getWorld().getConfig().RENDER_TRANSLUCENT_FLUIDS, region, biome, data, blockX, blockZ, pixelColor);
                        for (int color : data.getGlassColors()) {
                            pixelColor = Colors.blend(color, pixelColor);
                        }
                        int index = ((blockZ & 0x1FF) << 9) + (blockX & 0x1FF);
                        pixelMap[index] = pixelColor;
                        float diff = data.getFluidState() != null ? 1.0f : this.CalculateAltitudeDiff(region, blockX, blockZ, data.getBlockY());
                        shadowMap[index] = (byte)(128.0f * diff - 127.0f);
                    }
                }
            }
        }
        byte[] shadowMapCopy = (byte[])shadowMap.clone();
        BlurTool.Blur(shadowMap, 512, 512, 2);
        for (int i = 0; i < shadowMap.length; ++i) {
            float shadow = (float)((int)(((float)(shadowMap[i] + 127) / 128.0f - 1.0f) * 5.0f)) / 5.0f;
            int x = i & 0x1FF;
            int z = i >> 9;
            int index = (z << 9) + x;
            this.getTileImage().setPixel(x, z, pixelMap[index] == 0 ? 0 : Colors.mul(pixelMap[index], (shadow += ((float)(shadowMapCopy[i] + 127) / 128.0f - 1.0f) * 5.0f % 1.0f / 5.0f) * 1.4f + 1.0f) | 0xFF000000);
        }
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
    }

    private float CalculateAltitudeDiff(Region region, int blockX, int blockZ, int blockY) {
        Chunk.BlockData northwest = region.getWorld().getChunk(region, blockX - 1 >> 4, blockZ - 1 >> 4).getData(blockX - 1, blockZ - 1);
        Chunk.BlockData northeast = region.getWorld().getChunk(region, blockX >> 4, blockZ - 1 >> 4).getData(blockX, blockZ - 1);
        Chunk.BlockData southwest = region.getWorld().getChunk(region, blockX - 1 >> 4, blockZ >> 4).getData(blockX - 1, blockZ);
        int leftTop = blockY - (northwest == null ? blockY : northwest.getBlockY());
        int rightTop = blockY - (northeast == null ? blockY : northeast.getBlockY());
        int leftBot = blockY - (southwest == null ? blockY : southwest.getBlockY());
        int direction = Integer.signum(leftTop) + Integer.signum(rightTop) + Integer.signum(leftBot);
        int steepness = Math.max(Math.max(Math.abs(leftTop), Math.abs(rightTop)), Math.abs(leftBot));
        float slopeFactor = Math.min(0.5f, (float)steepness / 10.0f) / 1.25f;
        if (direction > 0) {
            return 1.08f + slopeFactor;
        }
        if (direction < 0) {
            return 0.92f - slopeFactor;
        }
        return 1.0f;
    }
}

