/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.heightmap;

import net.pl3x.map.core.renderer.heightmap.Heightmap;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class HighContrastHeightmap
extends Heightmap {
    public HighContrastHeightmap() {
        super("high_contrast");
    }

    @Override
    public int getMax() {
        return 102;
    }

    @Override
    public int getColor(Region region, int blockX, int blockZ) {
        Chunk.BlockData origin = region.getWorld().getChunk(region, blockX >> 4, blockZ >> 4).getData(blockX, blockZ);
        Chunk.BlockData west = region.getWorld().getChunk(region, blockX - 1 >> 4, blockZ >> 4).getData(blockX - 1, blockZ);
        Chunk.BlockData north = region.getWorld().getChunk(region, blockX >> 4, blockZ - 1 >> 4).getData(blockX, blockZ - 1);
        int heightColor = 51;
        if (origin != null) {
            int y = origin.getBlockY();
            if (west != null) {
                heightColor = this.getColor(y, west.getBlockY(), heightColor, 68);
            }
            if (north != null) {
                heightColor = this.getColor(y, north.getBlockY(), heightColor, 68);
            }
        }
        return heightColor << 24;
    }
}

